<?php

namespace Visiosoft\PaymentModule\Helper;

use Visiosoft\PaymentModule\Payment\Contract\PaymentInterface;

class Payment
{

    public ?int $id;
    public ?int $userId;
    public ?int $transactionId;
    public ?int $stationId;
    public ?string $stationName;
    public ?string $createdAt;
    public ?string $usage;
    public ?string $amountExcludingVat;
    public ?string $amountIncludingVat;
    public ?string $vatAmount;
    public ?string $vatPercent;
    public ?object $paymentMethod;
    public ?PaymentStatus $status;
    public ?string $lastTry;
    public ?string $serviceMessage;

    public function __construct(PaymentInterface $payment)
    {
        $this->id = $payment->getId();
        $this->userId = $payment->getUserId();
        $this->transactionId = $payment->getTransactionId();
        $this->stationId = $payment->getStationId();
        $this->stationName = $payment->name;
        $this->createdAt = $payment->getCreatedAt();
        $this->usage= $payment->getUsage();
        $this->amountExcludingVat = $payment->getAmountExcludingVat();
        $this->amountIncludingVat = $payment->getAmountIncludingVat();
        $this->vatAmount = $payment->getVatAmount();
        $this->vatPercent = $payment->getVatPercent();
        $this->lastTry = $payment->getLastTry();
        $this->serviceMessage = $payment->getServiceMessage();

    }
}