<?php namespace Visiosoft\PaymentModule\Payment\Commands;
class Card extends Provider
{

    /**
     * @var mixed
     */
    public function __construct()
    {
        parent::__construct('card_save_provider');
    }

    /**
     * @param $cardHolderName
     * @param $cardNumber
     * @param $expireYear
     * @param $expireMonth
     * @param $cvc
     * @param $email
     * @param $cardUserKey
     * @param $cardAlias
     * @return array
     */
    public function createCard($cardHolderName, $cardNumber, $expireYear, $expireMonth, $cvc = null, $email = null, $cardUserKey = null, $cardAlias = null)
    {
        try {
            $createCard = $this->provider->createCard($cardHolderName, $cardNumber, $expireYear, $expireMonth, $cvc, $email, $cardUserKey, $cardAlias);
            if(!$createCard){
                return $this->formatOutput(false, [], trans("visiosoft.module.payment::message.cant_add_card"));
            }
            return $this->formatOutput(true, $createCard);
        } catch (\Exception $e) {
            $this->provider->logError($e);
            return $this->formatOutput(false, [], '', $e);
        }
    }

    /**
     * @return array
     */
    public function getUserCards($userID)
    {
        try {
            $getUserCards = $this->provider->getUserCards($userID);
            return $this->formatOutput(true, $getUserCards);
        } catch (\Exception $e) {
            $this->provider->logError($e);
            return $this->formatOutput(false, [], '', $e);
        }
    }

    /**
     * @param $cardID
     * @return array
     */
    public function removeCard($cardID)
    {
        try {
            $deleteCard = $this->provider->removeCard($cardID);
            return $this->formatOutput($deleteCard, []);
        } catch (\Exception $e) {
            $this->provider->logError($e);
            return $this->formatOutput(false, [], '', $e);
        }
    }

}