<?php namespace Visiosoft\PaymentModule\Listener;

use Visiosoft\PaymentModule\Event\PaymentCreatedEvent;
use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;

class PayCreatedListener
{
    public function handle(PaymentCreatedEvent $event)
    {
        $paymentRepository = app(PaymentRepositoryInterface::class);
        try {
            $paymentRepository->doPay($event->paymentID);
        } catch (\Exception $e) {
            error_log("Payment ID: " . $event->paymentID . "," . $e->getMessage());
        }
    }
}