<?php namespace Visiosoft\PaymentModule\PaymentMethod;

use Visiosoft\PaymentModule\PaymentMethod\Contract\PaymentMethodRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class PaymentMethodRepository extends EntryRepository implements PaymentMethodRepositoryInterface
{

    protected $model;

    public function __construct(PaymentMethodModel $model)
    {
        $this->model = $model;
    }

    public function addPaymentMethod(array $params)
    {
        $isDefault = false;
        if ($this->newQuery()->count() == 0) {
            $isDefault = true;
        }
        if (!empty($params['billing_details'])) {
            $params['billing_details'] = (string)json_encode($params['billing_details']);
        }

        if (!empty($params['card'])) {
            $params['card'] = (string)json_encode($params['card']);
        }
        $params['metadata'] = null;
        if (!empty($params['metadata'])) {
            $params['metadata'] = (string)json_encode($params['metadata']);
        }
        if (!empty($params['name'])) {
            $params['holder_name'] = $params['name'];
            unset($params['name']);
        }
        $params['default'] = $isDefault;
        return $this->newQuery()->create($params);
    }
}
