<?php namespace Visiosoft\PaymentModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\Payment\PaymentStatusEntryModel;
use Visiosoft\PaymentModule\Console\Command\AutoInvoiceCommand;
use Visiosoft\PaymentModule\Event\InvoiceDownloadEvent;
use Visiosoft\PaymentModule\Listener\CreateInvoiceListener;
use Visiosoft\PaymentModule\Listener\InvoiceDownloadListener;
use Visiosoft\PaymentModule\Listener\PayCreatedListener;
use Visiosoft\PaymentModule\Listener\PaymentApprovedListener;
use Visiosoft\PaymentModule\Listener\PaymentCancelledListener;
use Visiosoft\PaymentModule\Listener\PaymentStartedListener;
use Visiosoft\PaymentModule\Listener\StirpePaymentChargeSucceededListener;
use Visiosoft\PaymentModule\Listener\StripePaymentIntentCreatedListener;
use Visiosoft\PaymentModule\Listener\SwishPaymentCreatedListener;
use Visiosoft\PaymentModule\Listener\SwishPaymentResultListener;
use Visiosoft\PaymentModule\Payment\PaymentObserver;
use Visiosoft\PaymentModule\PaymentMethod\Contract\PaymentMethodRepositoryInterface;
use Visiosoft\PaymentModule\PaymentMethod\PaymentMethodRepository;
use Anomaly\Streams\Platform\Model\Payment\PaymentPaymentMethodEntryModel;
use Visiosoft\PaymentModule\PaymentMethod\PaymentMethodModel;
use Visiosoft\PaymentModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\PaymentModule\Category\CategoryRepository;
use Anomaly\Streams\Platform\Model\Payment\PaymentCategoryEntryModel;
use Visiosoft\PaymentModule\Category\CategoryModel;
use Anomaly\Streams\Platform\Model\Payment\PaymentPaymentEntryModel;
use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\PaymentModule\Payment\PaymentModel;
use Visiosoft\PaymentModule\Payment\PaymentRepository;
use Visiosoft\PaymentModule\Status\Contract\StatusRepositoryInterface;
use Visiosoft\PaymentModule\Status\StatusModel;
use Visiosoft\PaymentModule\Status\StatusRepository;
use Visiosoft\PaymentStripeExtension\Event\PaymentChargeSucceededEvent;
use Visiosoft\PaymentStripeExtension\Event\PaymentIntentCreatedEvent;
use Visiosoft\PaypalWebhooksExtension\Events\OrderApproved;
use Visiosoft\PaypalWebhooksExtension\Events\OrderCancelled;
use Visiosoft\PaypalWebhooksExtension\Events\PaymentStarted;
use Visiosoft\SwishModule\Event\PaymentCreatedEvent;
use Visiosoft\SwishModule\Event\PaymentResultEvent;

class PaymentModuleServiceProvider extends AddonServiceProvider
{
    protected $commands = [
        AutoInvoiceCommand::class,
    ];

    protected $routes = [
        '/payment/cancel' => 'Visiosoft\PaymentModule\Http\Controller\PaymentController@cancelPage',
        '/payment/success' => [
            'as' => 'visiosoft.module.payment::payment_success',
            'uses' => 'Visiosoft\PaymentModule\Http\Controller\PaymentController@successPage'
        ],
        '/invoice/download/{stripePaymentIntent}' => 'Visiosoft\PaymentModule\Http\Controller\PaymentController@invoice',
        '/invoice/email/{stripePaymentIntent}' => 'Visiosoft\PaymentModule\Http\Controller\PaymentController@invoiceEmail',
        'admin/payment/payment_methods' => 'Visiosoft\PaymentModule\Http\Controller\Admin\PaymentMethodController@index',
        'admin/payment/payment_methods/create' => 'Visiosoft\PaymentModule\Http\Controller\Admin\PaymentMethodController@create',
        'admin/payment/payment_methods/edit/{id}' => 'Visiosoft\PaymentModule\Http\Controller\Admin\PaymentMethodController@edit',
        'admin/payment/category' => 'Visiosoft\PaymentModule\Http\Controller\Admin\CategoryController@index',
        'admin/payment/category/create' => 'Visiosoft\PaymentModule\Http\Controller\Admin\CategoryController@create',
        'admin/payment/category/edit/{id}' => 'Visiosoft\PaymentModule\Http\Controller\Admin\CategoryController@edit',
        'admin/payment' => 'Visiosoft\PaymentModule\Http\Controller\Admin\PaymentController@index',
        'admin/payment/create' => 'Visiosoft\PaymentModule\Http\Controller\Admin\PaymentController@create',
        'admin/payment/edit/{id}' => 'Visiosoft\PaymentModule\Http\Controller\Admin\PaymentController@edit',
        'admin/payment/status' => 'Visiosoft\PaymentModule\Http\Controller\Admin\StatusController@index',
        'admin/payment/status/create' => 'Visiosoft\PaymentModule\Http\Controller\Admin\StatusController@create',
        'admin/payment/status/edit/{id}' => 'Visiosoft\PaymentModule\Http\Controller\Admin\StatusController@edit',
        'cron/check-pending-payment' => 'Visiosoft\PaymentModule\Http\Controller\PaymentController@checkPendingPayment',
        'cron/check-balance-over-limit' => 'Visiosoft\PaymentModule\Http\Controller\PaymentController@checkBalanceOverLimit',
        'invoice' => 'Visiosoft\PaymentModule\PaymentModule@invoice',
        'get_vehicle/{plate}' => 'Visiosoft\PaymentModule\Http\Controller\PaymentController@getVehicle',
        '/payment/list-by-park-and-plate/{plate?}/{parkId?}' => [
            'as' => 'visiosoft.module.payment::list_by_plate_and_park',
            'uses' => 'Visiosoft\PaymentModule\Http\Controller\PaymentController@listByPlateAndPark'
        ],
        'pay-with-card' => 'Visiosoft\PaymentModule\Http\Controller\PaymentController@pay',
    ];

    protected $listeners = [
        OrderApproved::class => [
            PaymentApprovedListener::class
        ],
        OrderCancelled::class => [
            PaymentCancelledListener::class
        ],
        PaymentStarted::class => [
            PaymentStartedListener::class
        ],
        PaymentIntentCreatedEvent::class => [
            StripePaymentIntentCreatedListener::class
        ],
        PaymentChargeSucceededEvent::class => [
            StirpePaymentChargeSucceededListener::class
        ],
        InvoiceDownloadEvent::class => [
            InvoiceDownloadListener::class
        ],
        PaymentCreatedEvent::class => [
            SwishPaymentCreatedListener::class
        ],
        PaymentResultEvent::class => [
            SwishPaymentResultListener::class
        ],
        \Visiosoft\PaymentModule\Event\PaymentCreatedEvent::class => [
            PayCreatedListener::class,
            CreateInvoiceListener::class
        ]
    ];

    protected $bindings = [
        PaymentPaymentMethodEntryModel::class => PaymentMethodModel::class,
        PaymentCategoryEntryModel::class => CategoryModel::class,
        PaymentPaymentEntryModel::class => PaymentModel::class,
        PaymentStatusEntryModel::class => StatusModel::class,
    ];

    protected $singletons = [
        PaymentMethodRepositoryInterface::class => PaymentMethodRepository::class,
        CategoryRepositoryInterface::class => CategoryRepository::class,
        PaymentRepositoryInterface::class => PaymentRepository::class,
        StatusRepositoryInterface::class => StatusRepository::class,
    ];

    protected $providers = [
        \Barryvdh\DomPDF\ServiceProvider::class,
    ];

    public function boot()
    {
        PaymentModel::observe(PaymentObserver::class);
    }
}
