<?php namespace Visiosoft\PaymentModule;

use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Anomaly\Streams\Platform\Addon\Module\Module;
use Anomaly\Streams\Platform\Image\Command\MakeImageInstance;
use Anomaly\Streams\Platform\Ui\Table\Component\View\View;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use League\Flysystem\MountManager;
use Visiosoft\ChargingModule\Transaction\Contract\TransactionRepositoryInterface;
use Visiosoft\ParkingModule\Park\Contract\PricingCostCalculateHelperInterface;
use Visiosoft\ParkingModule\ParkingSession\Contract\ParkingSessionRepositoryInterface;
use Visiosoft\PaymentModule\Job\AutoInvoiceJob;
use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\PaymentModule\Payment\PaymentModel;
use Visiosoft\PaymentModule\Payment\PaymentWithoutAttrModel;

class PaymentModule extends Module
{
    protected $root_menu = 'Drifter';

    protected $navigation = true;

    protected $icon = 'fa fa-puzzle-piece';

    protected $sections = [
        'payment',
        'payment_methods',
        'category' => [
            'buttons' => [
                'new_category',
            ],
        ],
        'status'
    ];

    public function getFees($includedVatAmount)
    {
        $fixedAdministrationFee = setting_value('visiosoft.module.payment::fixed_administration_fee');
        $vatPercent = setting_value('visiosoft.module.invoice::vat');
        $fixedAdministrationFeePercent = setting_value('visiosoft.module.payment::fixed_administration_fee_percent');
        $output = [
            'total_amount_included_vat' => 0,
            'total_vat_amount' => 0,
            'payment_amount' => 0,
            'administration_fee' => 0,
            'administration_fee_vat_amount' => 0,
            'vat_percent' => $vatPercent
        ];
        if ($includedVatAmount > 0) {
            $administrationFee = (($fixedAdministrationFeePercent / 100) * $includedVatAmount) + $fixedAdministrationFee;
            $administrationFeeVatAmount = 0;
            $vatAmount = round($includedVatAmount - $includedVatAmount / (1 + ($vatPercent / 100)), 2);
            $totalVatAmount = $vatAmount + $administrationFeeVatAmount;
            $totalPaymentAmount = $includedVatAmount + $administrationFee;
            $output['total_amount_included_vat'] = round($includedVatAmount, 2);
            $output['total_vat_amount'] = round($totalVatAmount, 2);
            $output['payment_amount'] = round($totalPaymentAmount, 2);
            $output['administration_fee'] = round($administrationFee, 2);
            $output['administration_fee_vat_amount'] = $administrationFeeVatAmount;
        }
        return $output;
    }
}
