<?php namespace Visiosoft\PaymentModule\Console\Command;

use Illuminate\Console\Command;
use Visiosoft\PaymentModule\Job\AutoInvoiceJob;
use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\PaymentModule\Payment\PaymentWithoutAttrModel;
use function Clue\StreamFilter\fun;

class AutoInvoiceCommand extends Command
{
    protected $signature = 'invoice:auto {paymentId}';
    protected $description = 'auto charge over limit';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $paymentRepository = app(PaymentRepositoryInterface::class);
        $paymentRepository->createPaymentInvoice($this->argument('paymentId'));
    }
}
