<?php namespace Visiosoft\PaymentModule\Payment\Commands;
class Card extends Provider
{

    /**
     * @var mixed
     */
    public function __construct()
    {
        parent::__construct('card_save_provider');
    }

    /**
     * @param $cardHolderName
     * @param $cardNumber
     * @param $expireYear
     * @param $expireMonth
     * @param $cvc
     * @param $email
     * @param $cardUserKey
     * @param $cardAlias
     * @return array
     */
    public function createCard($cardHolderName, $cardNumber, $expireYear, $expireMonth, $cvc = null, $email = null, $cardUserKey = null, $cardAlias = null)
    {
        try {
            if (method_exists($this->provider, 'createCard')) {
                // createCard method creates a new card
                $createCard = $this->provider->createCard($cardHolderName, $cardNumber, $expireYear, $expireMonth, $cvc, $email, $cardUserKey, $cardAlias);

                // TODO: must create an response/extension interface

                if (!$createCard) {
                    return $this->formatOutput(false, []);
                } elseif (isset($createCard["success"]) && !$createCard["success"]) {
                    return $this->formatOutput($createCard["success"], [], $createCard["message"]);
                }

                // createCard method returns card information and true
                return $this->formatOutput(true, $createCard);
            } else {
                // createCard method does not exist in $this->provider
                return $this->formatOutput(false, []);
            }
        } catch (\Exception $e) {
            $this->provider->logError($e);
            return $this->formatOutput(false, [], '', $e);
        }
    }

    /**
     * @return array
     */
    public function getUserCards($userID)
    {
        try {
            if (method_exists($this->provider, 'getUserCards')) {
                $getUserCards = $this->provider->getUserCards($userID);
                return $this->formatOutput(true, $getUserCards);
            } else {
                return $this->formatOutput(false, []);
            }
        } catch (\Exception $e) {
            $this->provider->logError($e);
            return $this->formatOutput(false, [], '', $e);
        }
    }

    /**
     * @param $cardID
     * @return array
     */
    public function removeCard($cardID)
    {
        try {
            if (method_exists($this->provider, 'removeCard')) {
                $deleteCard = $this->provider->removeCard($cardID);
                return $this->formatOutput($deleteCard, []);
            } else {
                return $this->formatOutput(false, []);
            }
        } catch (\Exception $e) {
            $this->provider->logError($e);
            return $this->formatOutput(false, [], '', $e);
        }
    }

}