<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class VisiosoftModulePaymentDeleteRemovedStreamTables extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::table('payment_payment', function (Blueprint $table) {
                if (Schema::hasColumn('payment_payment', 'park_id')) {
                    $table->dropColumn('park_id');
                }
        });


        $streamsTable = [
            'park',
        ];

        DB::table('streams_fields')
            ->where('namespace', 'payment')
            ->whereIn('slug', $streamsTable)
            ->delete();

        DB::statement('DELETE FROM default_streams_assignments
        WHERE field_id NOT IN (SELECT id FROM default_streams_fields)');
    }

}
