<?php namespace Visiosoft\PaymentModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\PaymentModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\PaymentModule\Category\CategoryRepository;
use Anomaly\Streams\Platform\Model\Payment\PaymentCategoryEntryModel;
use Visiosoft\PaymentModule\Category\CategoryModel;
use Anomaly\Streams\Platform\Model\Payment\PaymentPaymentEntryModel;
use Illuminate\Routing\Router;
use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\PaymentModule\Payment\PaymentModel;
use Visiosoft\PaymentModule\Payment\PaymentRepository;
use Visiosoft\PaymentModule\Status\Contract\StatusRepositoryInterface;
use Visiosoft\PaymentModule\Status\StatusModel;
use Visiosoft\PaymentModule\Status\StatusRepository;

class PaymentModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/payment/category'           => 'Visiosoft\PaymentModule\Http\Controller\Admin\CategoryController@index',
        'admin/payment/category/create'    => 'Visiosoft\PaymentModule\Http\Controller\Admin\CategoryController@create',
        'admin/payment/category/edit/{id}' => 'Visiosoft\PaymentModule\Http\Controller\Admin\CategoryController@edit',
        'admin/payment' => 'Visiosoft\PaymentModule\Http\Controller\Admin\PaymentController@index',
        'admin/payment/create' => 'Visiosoft\PaymentModule\Http\Controller\Admin\PaymentController@create',
        'admin/payment/edit/{id}' => 'Visiosoft\PaymentModule\Http\Controller\Admin\PaymentController@edit',
        'admin/payment/status' => 'Visiosoft\PaymentModule\Http\Controller\Admin\StatusController@index',
        'admin/payment/status/create' => 'Visiosoft\PaymentModule\Http\Controller\Admin\StatusController@create',
        'admin/payment/status/edit/{id}' => 'Visiosoft\PaymentModule\Http\Controller\Admin\StatusController@edit',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\PaymentModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\PaymentModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\PaymentModule\Event\ExampleEvent::class => [
        //    Visiosoft\PaymentModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\PaymentModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        PaymentCategoryEntryModel::class => CategoryModel::class,
        PaymentPaymentEntryModel::class => PaymentModel::class,
        PaymentStatusEntryModel::class => StatusModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        CategoryRepositoryInterface::class => CategoryRepository::class,
        PaymentRepositoryInterface::class => PaymentRepository::class,
        StatusRepositoryInterface::class => StatusRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
