<?php namespace Visiosoft\PatronTheme;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Maatwebsite\Excel\ExcelServiceProvider;
use Maatwebsite\Excel\Facades\Excel;

class PatronThemeServiceProvider extends AddonServiceProvider
{

    protected $routes = [
        '/' => [
            'middleware' => 'auth',
            'uses' => 'Visiosoft\PatronModule\Http\Controller\HomeController@index'
        ],
    ];

    protected $aliases = [
        'Excel' => Excel::class,
    ];

    protected $providers = [
        ExcelServiceProvider::class,
    ];
    protected $overrides = [
        'anomaly.module.posts::posts/index'          => 'visiosoft.theme.base::addons/anomaly/posts-module/posts/index',
        'anomaly.module.posts::posts/view'           => 'visiosoft.theme.base::addons/anomaly/posts-module/posts/view',
        'anomaly.module.posts::posts/partials/posts' => 'visiosoft.theme.base::addons/anomaly/posts-module/posts/articles'
    ];
}
