// Column chart
google.charts.load('current', {packages: ['corechart', 'bar']});
google.charts.setOnLoadCallback(drawStacked);

function drawStacked() {

    var data = new google.visualization.DataTable();
    data.addColumn('date', trans.timeOfDay);
    data.addColumn('number', trans.unitCost);
    data.addColumn('number', trans.quantity);
    data.addColumn('number', trans.total);

    data.addRows(tableData);

    var options = {
        isStacked: true,
        hAxis: {
            format: 'MM/yy',
            gridlines: {
                color: 'transparent'
            }
        },
        series: {
            0: {color:'#0C4E88'},
            1: {color:'#588EBE'},
            2: {color:'#C7E4FF'},
        },
        bar: {groupWidth: "20%"},
        legend: {position: 'bottom'},
    };

    var container = document.getElementById('chart_div');
    var chart = new google.visualization.ColumnChart(container);
    chart.draw(data, options);
}
