<?php namespace Visiosoft\PatronModule;

use Anomaly\Streams\Platform\Addon\Module\Module;

class PatronModule extends Module
{

    /**
     * The navigation display flag.
     *
     * @var bool
     */
    protected $navigation = true;

    /**
     * The addon icon.
     *
     * @var string
     */
    protected $icon = 'fa fa-puzzle-piece';

    /**
     * The module sections.
     *
     * @var array
     */
    protected $sections = [
        'companies' => [
            'buttons' => [
                'new_company',
            ],
        ],
        'items' => [
            'buttons' => [
                'new_item',
            ],
        ],
        'synonyms' => [
            'buttons' => [
                'new_synonym',
            ],
        ],
        'expenses' => [
            'buttons' => [
                'new_expense',
            ],
        ],
        'analytics' => [
            'buttons' => [
                'new_analytic',
            ],
        ],
        'debts_and_receivables' => [
            'href' => '/admin/patron/debts-and-receivables',
            'buttons' => [
                'new_debt' => [
                    'type' => 'info',
                    'text' => 'visiosoft.module.patron::button.new_debt',
                    'href' => '/admin/patron/debts-and-receivables/create?type=debt'
                ],
                'new_receivables' => [
                    'text' => 'visiosoft.module.patron::button.new_receivables',
                    'href' => '/admin/patron/debts-and-receivables/create?type=receivable'
                ],
                'settings' => [
                    'text' => false,
                    'type' => 'primary',
                    'href' => false,
                    'dropdown' => [
                        'import' => [
                            'text' => 'visiosoft.module.patron::button.import',
                            'icon' => 'fa fa-upload',
                            'href' => '/admin/patron/debts-and-receivables/import'
                        ],
                        'add_field' => [
                            'attributes' => [
                                'data-toggle' => 'modal',
                                'data-target' => '#modal',
                            ],
                            'icon' => 'fa fa-plus',
                            'text' => 'streams::button.add_field',
                            'href' => 'admin/patron/fields/choose',
                        ],
                    ]
                ]
            ],
        ],
        'mizan' => [
            'buttons' => [
                'new_mizan',
            ],
        ],
        'import_mizan' => [
            'href' => '/admin/patron/import'
        ],
    ];

}
