<?php namespace Visiosoft\PatronModule\Mizan\Table;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Entry\EntryModel;

class MizanTableColumns
{

    public function handle(MizanTableBuilder $builder)
    {
        $columns = [
            'hesap_kodu' => [
                'sort_column' => 'hesap_kodu',
                'value' => function (EntryInterface $entry) {
                    if(strlen($entry->hesap_kodu) == 3 ) {
                        return "<b>".$entry->hesap_kodu."</b>";
                    } else {
                        return "->".$entry->hesap_kodu;
                    }
                }
            ],
            'name' => [
                'value' => function (EntryInterface $entry) {
                    if(strlen($entry->hesap_kodu) == 3 ) {
                        return "<b>".$entry->name."</b>";
                    } else {
                        return "".$entry->name;
                    }
                }
            ],
            'total'=> [
                'value' => function (EntryInterface $entry) {
                    if(strlen($entry->hesap_kodu) == 3 ) {
                        return "<b>{{ entry.total|number_format(2, ',', '.') }}</b>";
                    } else {
                        return "{{ entry.total|number_format(2, ',', '.') }}";
                    }
                    }
                }
            ]
        ];
        $builder->setColumns($columns);
    }

}
