<?php namespace Visiosoft\PatronModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Addon\FieldType\FieldTypeCollection;
use Anomaly\Streams\Platform\Assignment\AssignmentModel;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Table\AssignmentTableBuilder;
use Anomaly\Streams\Platform\Field\Form\FieldFormBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Anomaly\UsersModule\Assignment\AssignmentObserver;
use Visiosoft\PatronModule\Debt\DebtModel;

class FieldsController extends AdminController
{
    public function index(AssignmentTableBuilder $table, DebtModel $debtModel)
    {
        AssignmentModel::observe(AssignmentObserver::class);

        return $table
            ->setOption('sortable', true)
            ->setStream($debtModel->getStream())
            ->render();
    }

    public function choose(FieldTypeCollection $fieldTypes)
    {
        return $this->view->make('visiosoft.module.patron::admin/fields/choose', ['field_types' => $fieldTypes]);
    }

    public function create(FieldFormBuilder $form, DebtModel $debtModel, FieldTypeCollection $fieldTypes)
    {
        $form
            ->setStream($debtModel->getStream())
            ->setOption('auto_assign', true)
            ->setFieldType($fieldTypes->get($this->request->get('field_type')));

        return $form->render();
    }

    public function edit(AssignmentRepositoryInterface $assignments, FieldFormBuilder $form, DebtModel $debtModel, $id)
    {
        $assignment = $assignments->find($id);

        return $form
            ->setStream($debtModel->getStream())
            ->render($assignment->getFieldId());
    }
}
