<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModulePatronCreateCompaniesStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'companies',
        'title_column' => 'name',
        'translatable' => false,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'name' => [
            'required' => true,
        ],
        'slug' => [
            'unique' => true,
            'required' => true,
        ],
        'phone' => [
            'unique' => true,
            'required' => true,
        ],
        'tax_number' => [
            'unique' => true,
            'required' => true,
        ],
        "users",
    ];

}
