<?php namespace Visiosoft\PatronModule\Mizan\Table;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Entry\EntryModel;

class MizanTableColumns
{

    public function handle(MizanTableBuilder $builder)
    {
        $columns = [
            'hesap_kodu' => [
                'sort_column' => 'hesap_kodu',
                'value' => function (EntryInterface $entry) {
                    if (strlen($entry->hesap_kodu) <= 3) {
                        return "<b>" . $entry->hesap_kodu . "</b>";
                    } else {
                        return "<span style='color: gray;'>-->" . $entry->hesap_kodu . "</span>";
                    }
                }
            ],
            'name' => [
                'heading' => 'Hesap Adı',
                'value' => function (EntryInterface $entry) {
                    if (strlen($entry->hesap_kodu) <= 3) {
                        return "<b>" . $entry->name . "</b>";
                    } else {
                        return "<span style='color: gray;'>" . $entry->name."</span>";
                    }
                }
            ],
            'total' => [
                'heading' => 'Tutar (TL)',
                'value' => function (EntryInterface $entry) {
                    if (strlen($entry->hesap_kodu) <= 3) {
                        return "<b>{{ entry.total|round|number_format(0, ',', '.') }}</b>";
                    } else {
                        return "<span style='color: gray;'>{{ entry.total|round|number_format(0, ',', '.') }}</span>";
                    }
                }
            ],
            'real_value' => [
                'value' => function (EntryInterface $entry) {
                    if (strlen($entry->hesap_kodu) <= 3) {
                        return "<b>{{ entry.real_value|round|number_format(0, ',', '.') }}</b>";
                    } else {
                        return "<span style='color: gray;'>{{ entry.real_value|round|number_format(0, ',', '.') }}</span>";
                    }
                }
            ],
            'date' => [
                'value' => function (EntryInterface $entry) {
                    if (strlen($entry->hesap_kodu) <= 3) {
                        return "<b>{{ entry.date|date('d/m/Y') }}</b>";
                    } else {
                        return "<span style='color: gray;'>{{ entry.date|date('d/m/Y') }}</span>";
                    }
                }
            ]
        ];
        $builder->setColumns($columns);
    }

}
