<?php namespace Visiosoft\PatronModule\Http\Controller\Admin;

use Anomaly\FilesModule\Disk\Contract\DiskRepositoryInterface;
use Anomaly\FilesModule\File\Contract\FileRepositoryInterface;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Illuminate\Support\Str;
use SimpleXLSX;
use Visiosoft\IncomeModule\Income\Contract\IncomeRepositoryInterface;
use Visiosoft\IncomeModule\Synonym\SynonymRepository;
use Visiosoft\PatronModule\Company\Contract\CompanyRepositoryInterface;
use Visiosoft\PatronModule\Company\Form\CompanyFormBuilder;
use Visiosoft\PatronModule\Company\Table\CompanyTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\PatronModule\Expense\Contract\ExpenseRepositoryInterface;
use Visiosoft\PatronModule\Item\Contract\ItemRepositoryInterface;
use Visiosoft\PatronModule\Mizan\Contract\MizanRepositoryInterface;
use Visiosoft\PatronModule\Synonym\Contract\SynonymRepositoryInterface;
use Visiosoft\PatronModule\Traits\PatronTrait;

class CompaniesController extends AdminController
{
    use PatronTrait;

    protected $item_patron;
    protected $item_income;
    protected $company;
    protected $expense;
    protected $synonym_patron_Repository;
    protected $synonym_income_Repository;
    protected $income;
    protected $mizan;

    public function __construct(
        ItemRepositoryInterface $itemPatronRepository,
        CompanyRepositoryInterface $companyRepository,
        MizanRepositoryInterface $mizanRepository,
        ExpenseRepositoryInterface $expenseRepository,
        \Visiosoft\IncomeModule\Synonym\Contract\SynonymRepositoryInterface $synonymIncomeRepository,
        SynonymRepositoryInterface $synonymPatronRepository,
        IncomeRepositoryInterface $incomeRepository,
        \Visiosoft\IncomeModule\Item\Contract\ItemRepositoryInterface $itemIncomeRepository
    )
    {
        $this->item_patron = $itemPatronRepository;
        $this->item_income = $itemIncomeRepository;
        $this->company = $companyRepository;
        $this->mizan = $mizanRepository;
        $this->expense = $expenseRepository;
        $this->synonym_patron_Repository = $synonymPatronRepository;
        $this->synonym_income_Repository = $synonymIncomeRepository;
        $this->income = $incomeRepository;
        parent::__construct();
    }

    /**
     * Display an index of existing entries.
     *
     * @param CompanyTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(CompanyTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param CompanyFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(CompanyFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param CompanyFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(CompanyFormBuilder $form, $id)
    {
        return $form->render($id);
    }


}
