<?php namespace Visiosoft\PatronModule\Expense\Table;

class ExpenseTableColumns
{
    public function handle(ExpenseTableBuilder $builder)
    {
        $builder->setColumns([
            'item' => [
                'wrapper' => '{value.name}<span class="pl-1 text-muted">({value.hesap_kodu})</span>',
                'value' => [
                    'name' => 'entry.item.name',
                    'hesap_kodu' => 'entry.item.hesap_kodu'
                ],
            ],
            'total',
            'date' => [
                'value' => "entry.date.format('M Y')",
            ],
        ]);
    }
}
