<?php namespace Visiosoft\PatronModule\Mizan\Table;

use Visiosoft\PatronModule\Mizan\Table\Filter\DateFilterQuery;


use Visiosoft\PatronModule\Mizan\MizanRepository;

class MizanTableFilters
{
    public function handle(MizanTableBuilder $builder, MizanRepository $mizanRepository)
    {
        // Select RAW yapıp as yapmadan çalışmadı. İlginç.
        $months = $mizanRepository->newQuery()->groupBy('date')->selectRAW( 'date as tarih, id')->get();

        $months = $months->pluck('tarih','tarih')->all();

        $builder->setFilters(
            [
                'month' => [
                    'exact' => true,
                    'filter' => 'select',
                    'query' => DateFilterQuery::class,
                    'options' => $months,
                    'placeholder' => 'Mizan seçiniz'
                ]
            ]
        );
    }
}
