<?php namespace Visiosoft\PatronModule\Company\Form;

class CompanyFormFields
{

    public function handle(CompanyFormBuilder $builder)
    {
        $builder->setFields([
            'name',
            'slug',
            'phone',
            'tax_number',
            "users",
            "activity_area" => [
                'type' => 'anomaly.field_type.select',
                'config' => [
                    'options' => function () {
                        $values = config('patron::activity_area_values');
                        if(is_array($values))
                        {
                            $values = array_combine($values,$values);
                        }

                        $values = ($values) ? $values : [];

                        return $values;
                    }
                ],
            ],
            'land_phone',
            'email',
            'nace_kodu',
            'cari_oran_reference_value',
            'likidite_oran_reference_value',
            'nakit_orani_reference_value',
            'alacak_tahsil_reference_value',
            'borc_odeme_reference_value',
            'stokta_tutma_reference_value',
            'nakde_donusum_reference_value',
        ]);
    }

}
