<?php namespace Visiosoft\PatronModule\Traits;

use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Visiosoft\PatronModule\Company\Contract\CompanyRepositoryInterface;

trait PatronTrait
{

    protected function getIncomeOrExpenseAnalytics($incomeOrExpenseRepository)
    {
        $mainIncomeOrExpense = $incomeOrExpenseRepository->first();

        $analytics = array();
        if ($mainIncomeOrExpense) {
            $incomesOrExpenses = $incomeOrExpenseRepository->newQuery()
                ->where('item_id', $mainIncomeOrExpense->item_id)
                ->get()
                ->groupBy(function ($date) {
                    return Carbon::parse($date->date)->format('m');
                });

            foreach ($incomesOrExpenses as $month => $incomeOrExpense) {
                $calledByName = class_basename($incomeOrExpenseRepository) === 'ExpenseRepository' ?
                    'expense' : 'income';
                $analytic = $this->analyticRepository->findBy($calledByName . '_id', $incomeOrExpense[0]->id);
                if ($analytic) {
                    $total = $incomeOrExpense[0]->total;
                    $entityCount = $analytic->entity_count;
                    switch ($analytic->operator) {
                        case '/':
                            $unitCost = $total / $entityCount;
                            break;
                        case '*':
                            $unitCost = $total * $entityCount;
                            break;
                        case '-':
                            $unitCost = $total - $entityCount;
                            break;
                        case '+':
                            $unitCost = $total + $entityCount;
                            break;
                    }
                    $analytic->unit_cost = round($unitCost, 2);
                    $analytics[] = [
                        $calledByName => $incomeOrExpense[0],
                        'analytics' => $analytic
                    ];
                } else {
                    unset($incomesOrExpenses[$month]);
                }
            }
        }

        return $analytics;
    }

    public function getActiveCompany()
    {
        $companyRepository = app(CompanyRepositoryInterface::class);
        return $companyRepository->newQuery()
            ->leftJoin('patron_companies_users', 'patron_companies.id', 'patron_companies_users.entry_id')
            ->where('related_id', Auth::id())
            ->orderByDesc('patron_companies.id')
            ->first();
    }
}