<?php namespace Visiosoft\PatronModule\Mizan\Table;

use Illuminate\Support\Facades\Auth;
use Visiosoft\PatronModule\Company\Contract\CompanyRepositoryInterface;
use Visiosoft\PatronModule\Mizan\Table\Filter\DateFilterQuery;


use Visiosoft\PatronModule\Mizan\MizanRepository;

class MizanTableFilters
{
    public function getActiveCompany()
    {
        $companyRepository = app(CompanyRepositoryInterface::class);
        $com = $companyRepository->newQuery()
            ->leftJoin('patron_companies_users', 'patron_companies.id', 'patron_companies_users.entry_id')
            ->where('related_id', Auth::id())
            ->orderByDesc('patron_companies.id')
            ->select('patron_companies.*')
            ->first();
        if ($com == null) {
            die("Aktif şirketiniz bulunmuyor. Lütfen müşteri hizmetlerinden destek alınız. ");
        }
        return $com;
    }

    public function handle(MizanTableBuilder $builder, MizanRepository $mizanRepository)
    {
        $company = $this->getActiveCompany();

        // Select RAW yapıp as yapmadan çalışmadı. İlginç.
        $months = $mizanRepository->newQuery()
            ->where('company_id', $company->getId())
            ->groupBy('date')
            ->selectRAW( 'date as tarih, id')->get();

        $months = $months->pluck('tarih','tarih')->all();

        $builder->setFilters(
            [
                'month' => [
                    'exact' => true,
                    'filter' => 'select',
                    'query' => DateFilterQuery::class,
                    'options' => $months,
                    'placeholder' => 'Mizan seçiniz'
                ]
            ]
        );
    }
}
