<?php namespace Visiosoft\PatronModule\Mizan\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Auth;
use Visiosoft\PatronModule\Company\Contract\CompanyRepositoryInterface;

class MizanTableBuilder extends TableBuilder
{
    public function getActiveCompany()
    {
        $companyRepository = app(CompanyRepositoryInterface::class);
        $com = $companyRepository->newQuery()
            ->leftJoin('patron_companies_users', 'patron_companies.id', 'patron_companies_users.entry_id')
            ->where('related_id', Auth::id())
            ->orderByDesc('patron_companies.id')
            ->select('patron_companies.*')
            ->first();
        if ($com == null) {
            die("Aktif şirketiniz bulunmuyor. Lütfen müşteri hizmetlerinden destek alınız. ");
        }
        return $com;
    }

    public function onQuerying(Builder $query)
    {
        $company = $this->getActiveCompany();

        $query->where('company_id', $company->getId());

        $query->orderBy("date", "desc");

        if (request('show_subs') != "yes") {
            $query->where('hesap_kodu', 'not like', "120.%");
            $query->where('hesap_kodu', 'not like', "320.%");
            $query->where('hesap_kodu', 'not like', "102.%");
            $query->where('hesap_kodu', 'not like', "300.%");
        }
    }
    // we use custom filters
    //    protected $filters = [
    //        'date'
    //    ];

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete'
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [
        'order_by' => [
            'hesap_kodu' => 'ASC',
        ]
    ];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
