<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModulePatronCreateCodeNoteStream extends Migration
{
    protected $delete = false;

    protected $fields = [
        'mizan_hesap_note' => [
            'type' => 'anomaly.field_type.wysiwyg',
            'config' => [
                'height' => 500,
            ],
        ],
        'mizan_hesap_kodu' => 'anomaly.field_type.integer',
    ];
    protected $stream = [
        'slug' => 'code_note',
        'title_column' => 'mizan_hesap_kodu',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    protected $assignments = [
        'mizan_hesap_kodu' => [
            'required' => true,
            'unique' => true,
        ],
        'mizan_hesap_note' => [
            'required' => true,
        ],
    ];

}
