<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModulePatronAddedCompanyForExpenses extends Migration
{
    protected $stream = [
        'slug' => 'expenses',
    ];

    protected $fields = [
        "company" => [
            "type" => "anomaly.field_type.relationship",
            "config" => [
                "related" => \Visiosoft\PatronModule\Expense\ExpenseModel::class,
                "mode" => "search",
                "handler" => "Visiosoft\PatronModule\Analytic\Form\ExpenseOptions@handle",
            ]
        ]
    ];

    protected $assignments = [
        'company' => [
            'required' => true,
        ],
    ];
}
