<?php namespace Visiosoft\PatronModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\PatronModule\Mizan\Contract\MizanRepositoryInterface;
use Visiosoft\PatronModule\Traits\PatronTrait;

class HomeController extends PublicController
{
    use PatronTrait;

    protected $mizanRepository;

    public function __construct(MizanRepositoryInterface $mizanRepository)
    {
        $this->mizanRepository = $mizanRepository;
        parent::__construct();
    }

    public function index()
    {
        return $this->view->make('visiosoft.theme.patron::layouts/default');
    }

    public function workingCapital()
    {
        $company = $this->getActiveCompany();

        $now = now();
        $month = $now->format('m');
        $year = $now->format('Y');

        //last record
        if ($last_date = $this->mizanRepository->newQuery()->select(['date'])->orderByDesc('date')->first()) {
            $last_date = $last_date->date;
            $month = $last_date->format('m');
            $year = $last_date->format('Y');
        }

        //filter record
        if ($this->request->has('date')) {
            $date = explode('-', $this->request->get('date'));

            $month = end($date);
            $year = array_first($date);
        }


        $entries = $this->mizanRepository->newQuery()
            ->where('company_id', $company->getId())
            ->whereRaw('LENGTH(hesap_kodu) < 4 AND LENGTH(hesap_kodu) > 2')
            ->whereRaw('MONTH(date) = ' . $month)
            ->whereRaw('YEAR(date) = ' . $year)
            ->get();

        $formatted_entries = array();
        foreach ($entries as $entry) {
            $formatted_entries[$entry->hesap_kodu] = $entry->toArray();
        }

        $main_groups = json_decode(file_get_contents(__DIR__ . "/calisma_sermayesi.json"), true);

        $details = array();

        foreach ($main_groups as $main_key => $main_group) {
            $details[$main_key]['name'] = $main_group['name'];
            $details[$main_key]['total_title'] = $main_group['total_title'];
            if (!isset($details[$main_key]['total'])) {
                $details[$main_key]['total'] = 0;
            }
            if (!isset($details[$main_key]['real_value'])) {
                $details[$main_key]['real_value'] = 0;
            }
            foreach ($main_group as $sub_key => $sub_group) {
                if (!isset($details[$main_key]['total'])) {
                    $details[$main_key]['total'] = 0;
                }
                if (!isset($details[$main_key]['real_value'])) {
                    $details[$main_key]['real_value'] = 0;
                }
                if (is_array($sub_group)) {
                    foreach ($sub_group as $index => $item) {
                        if (!isset($details[$main_key][$sub_key]['total'])) {
                            $details[$main_key][$sub_key]['total'] = 0;
                        }
                        if (!isset($details[$main_key][$sub_key]['real_value'])) {
                            $details[$main_key][$sub_key]['real_value'] = 0;
                        }
                        if (array_key_exists($index, $formatted_entries)) {
                            $difference = ($formatted_entries[$index]['real_value'] and $formatted_entries[$index]['real_value'] > 0) ? $formatted_entries[$index]['total'] - $formatted_entries[$index]['real_value'] : 0;
                            $formatted_entries[$index]['minus'] = ($difference > 0) ? $difference : 0;
                            $formatted_entries[$index]['plus'] = ($difference < 0) ? $difference : 0;
                            $details[$main_key][$sub_key]['total'] = $details[$main_key][$sub_key]['total'] + $formatted_entries[$index]['total'];
                            $details[$main_key][$sub_key]['real_value'] = $details[$main_key][$sub_key]['real_value'] + $formatted_entries[$index]['real_value'];
                            $details[$main_key][$sub_key][$index] = $formatted_entries[$index];

                            $difference_group = ($details[$main_key][$sub_key]['real_value'] and $details[$main_key][$sub_key]['real_value'] > 0) ? $details[$main_key][$sub_key]['total'] - $details[$main_key][$sub_key]['real_value'] : 0;
                            $details[$main_key][$sub_key]['minus'] = ($difference_group > 0) ? $difference_group : 0;
                            $details[$main_key][$sub_key]['plus'] = ($difference_group < 0) ? $difference_group : 0;
                        }
                    }
                    $details[$main_key][$sub_key]['name'] = $main_group[$sub_key]['name'];

                    $details[$main_key]['total'] = $details[$main_key]['total'] + $details[$main_key][$sub_key]['total'];
                    $details[$main_key]['real_value'] = $details[$main_key]['real_value'] + $details[$main_key][$sub_key]['real_value'];

                    $difference_main = ($details[$main_key]['real_value'] and $details[$main_key]['real_value'] > 0) ? $details[$main_key]['total'] - $details[$main_key]['real_value'] : 0;
                    $details[$main_key]['minus'] = ($difference_main > 0) ? $difference_main : 0;
                    $details[$main_key]['plus'] = ($difference_main < 0) ? $difference_main : 0;
                }

            }
        }

        return $this->view->make('visiosoft.module.patron::working-capital', compact('details', 'main_groups', 'company', 'month', 'year'));
    }
}
