<?php namespace Visiosoft\PatronModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Carbon\Carbon;
use Visiosoft\PatronModule\Analytic\Contract\AnalyticRepositoryInterface;
use Visiosoft\PatronModule\Expense\Contract\ExpenseRepositoryInterface;

class HomeController extends PublicController
{

    private $expenseRepository;
    private $analyticRepository;

    public function __construct(
        ExpenseRepositoryInterface $expenseRepository,
        AnalyticRepositoryInterface $analyticRepository
    )
    {
        parent::__construct();
        $this->expenseRepository = $expenseRepository;
        $this->analyticRepository = $analyticRepository;
    }

    public function index()
    {
        $mainExpense = $this->expenseRepository->first();
        $expenses = $this->expenseRepository->newQuery()
            ->where('item_id', $mainExpense->item_id)
            ->get()
            ->groupBy(function($date) {
                return Carbon::parse($date->date)->format('m');
            });

        $analytics = array();
        foreach ($expenses as $month => $expense) {
            $analytic = $this->analyticRepository->findBy('expense_id', $expense[0]->id);
            if ($analytic) {
                $analytics[] = [
                    'expense' => $expense[0],
                    'analytics' => $analytic
                ];
            } else {
                unset($expenses[$month]);
            }
        }

        return $this->view->make(
            'visiosoft.theme.patron::layouts/default', [
                'analytics'  => $analytics,
            ]
        );
    }
}
