<?php namespace Visiosoft\PatronModule\Mizan\Form;


use Visiosoft\PatronModule\CodeNote\Contract\CodeNoteRepositoryInterface;

class MizanFormFields
{
    public function handle(MizanFormBuilder $builder)
    {
        $entry = $builder->getFormEntry();

        if ($entry->countChild() > 0) {
            $fields = ['note', 'reduction_note'];
        } else {
            $fields = [
                'name',
                'hesap_kodu',
                'total',
                'date',
                'company',
                'real_value' => [
                    'instructions' => function (CodeNoteRepositoryInterface $codeNoteRepository) use ($entry) {
                        if ($entry) {
                            $hesap_kodu = explode('.', $entry->hesap_kodu);
                            if ($code_note = $codeNoteRepository->newQuery()->where('mizan_hesap_kodu', array_first($hesap_kodu))->first()) {
                                return $code_note->mizan_hesap_note;
                            }
                        }
                    }
                ],
                'note',
                'reduction_note'
            ];
        }
        $builder->setFields($fields);
    }
}
