<?php namespace Visiosoft\PatronModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Carbon\Carbon;
use Visiosoft\IncomeModule\Income\Contract\IncomeRepositoryInterface;
use Visiosoft\IncomeModule\Item\Contract\ItemRepositoryInterface;
use Visiosoft\PatronModule\Mizan\Contract\MizanRepositoryInterface;
use Visiosoft\PatronModule\Traits\PatronTrait;

class HomeController extends PublicController
{
    use PatronTrait;

    protected $mizanRepository;
    protected $incomeItemRepository;
    protected $incomeRepository;

    public function __construct(MizanRepositoryInterface $mizanRepository, ItemRepositoryInterface $incomeItemRepository, IncomeRepositoryInterface $incomeRepository)
    {
        $this->mizanRepository = $mizanRepository;
        $this->incomeItemRepository = $incomeItemRepository;
        $this->incomeRepository = $incomeRepository;
        parent::__construct();
    }

    public function index()
    {
        return $this->view->make('visiosoft.theme.patron::layouts/default');
    }

    public function workingCapitalMonthly($return_detail = false)
    {
        $company = $this->getActiveCompany();

        $now = now();
        $month = $now->format('m');
        $year = $now->format('Y');

        //last record
        if ($last_date = $this->mizanRepository->newQuery()->select(['date'])->orderByDesc('date')->first()) {
            $last_date = $last_date->date;
            $month = $last_date->format('m');
            $year = $last_date->format('Y');
        }

        //filter record
        if ($this->request->has('date')) {
            $date = explode('-', $this->request->get('date'));

            $month = end($date);
            $year = array_first($date);
        }


        $entries = $this->mizanRepository->newQuery()
            ->where('company_id', $company->getId())
            ->whereRaw('LENGTH(hesap_kodu) < 4 AND LENGTH(hesap_kodu) > 2')
            ->whereRaw('MONTH(date) = ' . $month)
            ->whereRaw('YEAR(date) = ' . $year)
            ->get();

        $formatted_entries = array();
        foreach ($entries as $entry) {
            $formatted_entries[$entry->hesap_kodu] = $entry->toArray();
        }

        $main_groups = json_decode(file_get_contents(__DIR__ . "/calisma_sermayesi.json"), true);

        $details = array();

        foreach ($main_groups as $main_key => $main_group) {
            $details[$main_key]['name'] = $main_group['name'];
            $details[$main_key]['total_title'] = $main_group['total_title'];
            if (!isset($details[$main_key]['total'])) {
                $details[$main_key]['total'] = 0;
            }
            if (!isset($details[$main_key]['real_value'])) {
                $details[$main_key]['real_value'] = 0;
            }
            foreach ($main_group as $sub_key => $sub_group) {
                if (!isset($details[$main_key]['total'])) {
                    $details[$main_key]['total'] = 0;
                }
                if (!isset($details[$main_key]['real_value'])) {
                    $details[$main_key]['real_value'] = 0;
                }
                if (is_array($sub_group)) {
                    foreach ($sub_group as $index => $item) {
                        if (!isset($details[$main_key][$sub_key]['total'])) {
                            $details[$main_key][$sub_key]['total'] = 0;
                        }
                        if (!isset($details[$main_key][$sub_key]['real_value'])) {
                            $details[$main_key][$sub_key]['real_value'] = 0;
                        }
                        if (array_key_exists($index, $formatted_entries)) {
                            $difference = ($formatted_entries[$index]['real_value'] and $formatted_entries[$index]['real_value'] > 0) ? $formatted_entries[$index]['total'] - $formatted_entries[$index]['real_value'] : 0;
                            $formatted_entries[$index]['minus'] = ($difference > 0) ? $difference : 0;
                            $formatted_entries[$index]['plus'] = ($difference < 0) ? $difference : 0;
                            $details[$main_key][$sub_key]['total'] = $details[$main_key][$sub_key]['total'] + $formatted_entries[$index]['total'];
                            $details[$main_key][$sub_key]['real_value'] = $details[$main_key][$sub_key]['real_value'] + $formatted_entries[$index]['real_value'];
                            $details[$main_key][$sub_key][$index] = $formatted_entries[$index];

                            $difference_group = ($details[$main_key][$sub_key]['real_value'] and $details[$main_key][$sub_key]['real_value'] > 0) ? $details[$main_key][$sub_key]['total'] - $details[$main_key][$sub_key]['real_value'] : 0;
                            $details[$main_key][$sub_key]['minus'] = ($difference_group > 0) ? $difference_group : 0;
                            $details[$main_key][$sub_key]['plus'] = ($difference_group < 0) ? $difference_group : 0;
                        }
                    }
                    $details[$main_key][$sub_key]['name'] = $main_group[$sub_key]['name'];

                    $details[$main_key]['total'] = $details[$main_key]['total'] + $details[$main_key][$sub_key]['total'];
                    $details[$main_key]['real_value'] = $details[$main_key]['real_value'] + $details[$main_key][$sub_key]['real_value'];

                    $difference_main = ($details[$main_key]['real_value'] and $details[$main_key]['real_value'] > 0) ? $details[$main_key]['total'] - $details[$main_key]['real_value'] : 0;
                    $details[$main_key]['minus'] = ($difference_main > 0) ? $difference_main : 0;
                    $details[$main_key]['plus'] = ($difference_main < 0) ? $difference_main : 0;
                }

            }
        }

        if ($return_detail) {
            return $details;
        }

        return $this->view->make('visiosoft.module.patron::working-capital-monthly', compact('details', 'main_groups', 'company', 'month', 'year'));
    }

    public function workingCapital()
    {
        $company = $this->getActiveCompany();

        if ($company) {
            $last_date = $this->mizanRepository->newQuery()
                ->where('company_id', $company->id)
                ->select(['date'])->orderByDesc('date')->first();
            $first_date = $this->mizanRepository->newQuery()
                ->where('company_id', $company->id)
                ->select(['date'])->orderBy('date', 'ASC')->first();

            if (!$last_date and !$first_date) {
                abort(404);
            }
            $start_date = $last_date->date;//new Carbon('2020-03-01');
            $finish_date = $last_date->date;//new Carbon('2021-05-03');

            $months = [$start_date->format('m-Y')];

//        while ($start_date <= $finish_date) {
//            $start_date = $start_date->addMonths(1);
//            $months[] = $start_date->format('m-Y');
//        }

            //For 3 month
            for ($i = -1; $i >= -2; $i--) {
                $finish_date = $finish_date->addMonths(-1);
                $months[] = $finish_date->format('m-Y');
            }

            $main_groups = json_decode(file_get_contents(__DIR__ . "/calisma_sermayesi.json"), true);

            $details = array();

            foreach ($main_groups as $main_key => $main_group) {
                $details[$main_key]['name'] = $main_group['name'];
                foreach ($main_group as $sub_key => $sub_group) {
                    if (is_array($sub_group)) {
                        foreach ($sub_group as $index => $item) {
                            if ($index !== "name") {
                                foreach ($months as $month) {
                                    $date = explode('-', $month);
                                    if (!isset($details[$main_key][$sub_key]['child'][$month])) {
                                        $details[$main_key][$sub_key]['child'][$month] = 0;
                                    }

                                    $entries = $this->mizanRepository->newQuery()
                                        ->where('company_id', $company->getId())
                                        ->where('hesap_kodu', $index)
                                        ->whereRaw('MONTH(date) = ' . array_first($date))
                                        ->whereRaw('YEAR(date) = ' . end($date))
                                        ->orderByDesc('date')
                                        ->first();

                                    $total = ($entries) ? $entries->real_value : 0;
                                    $details[$main_key][$sub_key]['child'][$month] = $details[$main_key][$sub_key]['child'][$month] + $total;


                                    $details[$main_key][$sub_key]['items'][$index]['name'] = $item;
                                    $details[$main_key][$sub_key]['items'][$index][$month] = ($entries) ? $entries : 0;
                                }
                            } else {
                                $details[$main_key][$sub_key][$index] = $item;
                            }
                        }
                    }
                }
            }

            //Rander Years
            $years = [];
            foreach ($months as $month) {
                $year = new Carbon("01-" . $month);
                $year = $year->format('Y');
                if (!isset($years[$year])) {
                    $years[$year] = 0;
                }
                $years[$year] += 1;
            }

            //Calculate Total
            $total = array();
            foreach ($details as $main_key => $main) {
                if (is_array($main)) {
                    foreach ($main as $sub_key => $sub) {
                        if (is_array($sub)) {
                            foreach ($sub['child'] as $item_key => $item) {
                                if (!isset($total[$main_key][$item_key])) {
                                    $total[$main_key][$item_key] = 0;
                                }
                                if (!isset($total[$item_key])) {
                                    $total[$item_key] = 0;
                                }
                                $total[$main_key][$item_key] += $item;
                                $total[$item_key] += $item;
                            }
                        }

                    }
                }

            }

            return $this->view->make('visiosoft.module.patron::working-capital', compact('details', 'company', 'months', 'years', 'total'));
        }
        abort(404);
    }


    //Sermaye Yönetimi V6
    public function capitalManagementV6($type = "A")
    {
        $company = $this->getActiveCompany();

        if ($company) {
            $last_date = $this->mizanRepository->newQuery()
                ->where('company_id', $company->id)
                ->select(['date'])->orderByDesc('date')->first();
            $first_date = $this->mizanRepository->newQuery()
                ->where('company_id', $company->id)
                ->select(['date'])->orderBy('date', 'ASC')->first();

            if (!$last_date and !$first_date) {
                abort(404);
            }
            $start_date = $last_date->date;//new Carbon('2020-03-01');
            $finish_date = $last_date->date;//new Carbon('2021-05-03');

            $months = [$start_date->format('m-Y')];

//        while ($start_date <= $finish_date) {
//            $start_date = $start_date->addMonths(1);
//            $months[] = $start_date->format('m-Y');
//        }

            //For 3 month
            for ($i = -1; $i >= -2; $i--) {
                $finish_date = $finish_date->addMonths(-1);
                $months[] = $finish_date->format('m-Y');
            }

            $main_groups = json_decode(file_get_contents(__DIR__ . "/calisma_sermayesi.json"), true);

            $remove_type = ($type == "A") ? "B" : "A";

            unset($main_groups[$remove_type]);

            $details = array();

            foreach ($main_groups as $main_key => $main_group) {
                $details[$main_key]['name'] = $main_group['name'];
                foreach ($main_group as $sub_key => $sub_group) {
                    if (is_array($sub_group)) {
                        foreach ($sub_group as $index => $item) {
                            if ($index !== "name") {
                                foreach ($months as $month) {
                                    $date = explode('-', $month);
                                    if (!isset($details[$main_key][$sub_key]['child'][$month])) {
                                        $details[$main_key][$sub_key]['child'][$month] = 0;
                                    }

                                    $entries = $this->mizanRepository->newQuery()
                                        ->where('company_id', $company->getId())
                                        ->where('hesap_kodu', $index)
                                        ->whereRaw('MONTH(date) = ' . array_first($date))
                                        ->whereRaw('YEAR(date) = ' . end($date))
                                        ->orderByDesc('date')
                                        ->first();

                                    $total = ($entries) ? $entries->real_value : 0;
                                    $details[$main_key][$sub_key]['child'][$month] = $details[$main_key][$sub_key]['child'][$month] + $total;


                                    if (!isset($details[$main_key][$sub_key]['total_row_main'])) {
                                        $details[$main_key][$sub_key]['total_row_main'] = 0;
                                    }

                                    if (!isset($details[$main_key][$sub_key]['items'][$index]['total_row'])) {
                                        $details[$main_key][$sub_key]['items'][$index]['total_row'] = 0;
                                    }

                                    $details[$main_key][$sub_key]['items'][$index]['name'] = $item;
                                    $details[$main_key][$sub_key]['total_row_main'] += ($entries) ? $entries->total : 0;
                                    $details[$main_key][$sub_key]['items'][$index]['total_row'] += ($entries) ? $entries->total : 0;
                                    $details[$main_key][$sub_key]['items'][$index][$month] = ($entries) ? $entries : 0;
                                }
                            } else {
                                $details[$main_key][$sub_key][$index] = $item;
                            }
                        }
                    }
                }
            }

            //Rander Years
            $years = [];
            foreach ($months as $month) {
                $year = new Carbon("01-" . $month);
                $year = $year->format('Y');
                if (!isset($years[$year])) {
                    $years[$year] = 0;
                }
                $years[$year] += 1;
            }

            //DefaultMizan
            $default_mizan = [];

            $main_mizans = json_decode(file_get_contents(__DIR__ . "/default_mizan.json"), true);

            unset($main_mizans[$remove_type]);

            foreach ($main_mizans as $main_key => $main_group) {
                $default_mizan[$main_key]['name'] = $main_group['name'];
                foreach ($main_group as $sub_key => $sub_group) {
                    if (is_array($sub_group)) {
                        foreach ($sub_group as $index => $item) {
                            if ($index !== "name") {
                                foreach ($months as $month) {
                                    $date = explode('-', $month);
                                    if (!isset($default_mizan[$main_key][$sub_key]['child'][$month])) {
                                        $default_mizan[$main_key][$sub_key]['child'][$month] = 0;
                                    }

                                    $entries = $this->mizanRepository->newQuery()
                                        ->where('company_id', $company->getId())
                                        ->where('hesap_kodu', $index)
                                        ->whereRaw('MONTH(date) = ' . array_first($date))
                                        ->whereRaw('YEAR(date) = ' . end($date))
                                        ->orderByDesc('date')
                                        ->first();

                                    $total = ($entries) ? $entries->real_value : 0;
                                    $default_mizan[$main_key][$sub_key]['child'][$month] = $default_mizan[$main_key][$sub_key]['child'][$month] + $total;


                                    $default_mizan[$main_key][$sub_key]['items'][$index]['name'] = $item;
                                    $default_mizan[$main_key][$sub_key]['items'][$index][$month] = ($entries) ? $entries : 0;
                                }
                            } else {
                                $default_mizan[$main_key][$sub_key][$index] = $item;
                            }
                        }
                    }
                }
            }

            //Calculate Total
            $total = array();
            foreach ($details as $main_key => $main) {
                if (is_array($main)) {
                    foreach ($main as $sub_key => $sub) {
                        if (is_array($sub)) {
                            foreach ($sub['child'] as $item_key => $item) {
                                if (!isset($total[$main_key][$item_key])) {
                                    $total[$main_key][$item_key] = 0;
                                }
                                if (!isset($total[$item_key])) {
                                    $total[$item_key] = 0;
                                }
                                $total[$main_key][$item_key] += $item;
                                $total[$item_key] += $item;
                            }
                        }

                    }
                }

            }


            //Calculate Total Mizan
            $total_mizan = array();
            foreach ($default_mizan as $main_key => $main) {
                if (is_array($main)) {
                    foreach ($main as $sub_key => $sub) {
                        if (is_array($sub)) {
                            foreach ($sub['child'] as $item_key => $item) {
                                if (!isset($total_mizan[$main_key][$item_key])) {
                                    $total_mizan[$main_key][$item_key] = 0;
                                }
                                if (!isset($total_mizan[$item_key])) {
                                    $total_mizan[$item_key] = 0;
                                }
                                $total_mizan[$main_key][$item_key] += $item;
                                $total_mizan[$item_key] += $item;
                            }
                        }

                    }
                }
            }

            $main_toplam = array();

            foreach ($months as $month) {
                $main_toplam[$month] = $total[$type][$month] + $total_mizan[$type][$month];
            }

            return $this->view->make('visiosoft.module.patron::v6/capital-management', compact('details', 'type', 'company', 'months', 'years', 'total', 'default_mizan', 'main_toplam'));
        }
        abort(404);
    }

    public function dashboard()
    {
        $company = $this->getActiveCompany();
        if ($company) {

            $now = now();
            $month = $now->format('m');
            $year = $now->format('Y');

            //last record
            if ($last_date = $this->mizanRepository->newQuery()->select(['date'])->orderByDesc('date')->first()) {
                $last_date = $last_date->date;
                $month = $last_date->format('m');
                $year = $last_date->format('Y');
            }

            //filter record
            if ($this->request->has('date')) {
                $date = explode('-', $this->request->get('date'));

                $month = end($date);
                $year = array_first($date);
            }

            $detail = $this->workingCapitalMonthly(true);

            $stoklar_bu_ay = $this->getStoklarLast($company, $month, $year);

            //Cari Oran
            $calculated_cari = $this->getCariOran($detail);

            //Likidite Oranı
            $calculated_likidite = $this->getLikiditeOran($detail, $stoklar_bu_ay);

            // Nakit Oranı
            $calculated_nakit = $this->getNakitOrani($company, $month, $year, $detail);

            //Net Satışlar
            $net_satislar = $this->getNetSatislar($company, $month, $year);

            // Alacak Tahsil Süresi
            $calculated_alacak_tahsil = $this->getAlacakTahsilSuresi($company, $month, $year, $net_satislar);

            //Ortalama Ticari Borçlar
            $ortalama_ticari_borclar = $this->getOrtalamaTicariBorclar($company, $month, $year);

            // Borç Ödeme Süresi
            $calculated_borc_odeme = $this->getBorcOdemeSuresi($net_satislar, $ortalama_ticari_borclar);

            // Stokta Tutma Süresi
            $calculated_stokta_tutma = $this->getStoktaTutmaSuresi($stoklar_bu_ay, $company, $month, $year);

            // Nakde Dönüşüm Süresi
            $calculated_nakde_donusum = $this->getNakdeDonusumSuresi($calculated_alacak_tahsil, $calculated_stokta_tutma, $calculated_borc_odeme);

            return $this->view->make('visiosoft.module.patron::dashboard/dashboard', compact('company',
                'calculated_cari', 'calculated_likidite', 'calculated_nakit', 'calculated_alacak_tahsil',
                'calculated_borc_odeme', 'calculated_stokta_tutma', 'calculated_nakde_donusum'));
        }
        abort(404);
    }

    public function getOrtalamaTicariBorclar($company, $month, $year)
    {
        //Ortalama Ticari Borçlar
        $ortalama_ticari_borclar = null;
        $ticari_borclar_bu_ay = $this->mizanRepository->newQuery()
            ->where('company_id', $company->getId())
            ->where('hesap_kodu', '32')
            ->whereRaw('MONTH(date) = ' . $month)
            ->whereRaw('YEAR(date) = ' . $year)
            ->orderByDesc('date')
            ->first();

        if ($ticari_borclar_bu_ay) {
            $ticari_borclar_onceki_ay = $this->mizanRepository->newQuery()
                ->where('company_id', $company->getId())
                ->where('hesap_kodu', '32')
                ->where('date', '!=', $ticari_borclar_bu_ay->date)
                ->orderByDesc('date')
                ->first();

            if ($ticari_borclar_onceki_ay) {
                $ortalama_ticari_borclar = ($ticari_borclar_onceki_ay->total + $ticari_borclar_bu_ay->total) / 2;
            }
        }

        return $ortalama_ticari_borclar;
    }

    public function getAlacakTahsilSuresi($company, $month, $year, $net_satislar)
    {
        $calculated_alacak_tahsil = null;
        $ticari_alacaklar_bu_ay = $this->mizanRepository->newQuery()
            ->where('company_id', $company->getId())
            ->where('hesap_kodu', '12')
            ->whereRaw('MONTH(date) = ' . $month)
            ->whereRaw('YEAR(date) = ' . $year)
            ->orderByDesc('date')
            ->first();

        if ($ticari_alacaklar_bu_ay) {
            $ticari_alacaklar_onceki_ay = $this->mizanRepository->newQuery()
                ->where('company_id', $company->getId())
                ->where('hesap_kodu', '12')
                ->where('date', '!=', $ticari_alacaklar_bu_ay->date)
                ->orderByDesc('date')
                ->first();
            if ($ticari_alacaklar_onceki_ay) {
                $ortalama_ticari_alacaklar = ($ticari_alacaklar_onceki_ay->total + $ticari_alacaklar_bu_ay->total) / 2;

                if ($net_satislar) {
                    $calculated_alacak_tahsil = $ortalama_ticari_alacaklar / $net_satislar * 365;
                }
            }
        }

        return $calculated_alacak_tahsil;
    }

    public function getNakdeDonusumSuresi($calculated_alacak_tahsil, $calculated_stokta_tutma, $calculated_borc_odeme)
    {
        $calculated_nakde_donusum = null;
        if ($calculated_alacak_tahsil and $calculated_stokta_tutma and $calculated_borc_odeme) {
            $calculated_nakde_donusum = $calculated_alacak_tahsil + $calculated_stokta_tutma + $calculated_borc_odeme;
        }
        return $calculated_nakde_donusum;
    }

    public function getStoktaTutmaSuresi($stoklar_bu_ay, $company, $month, $year)
    {
        $calculated_stokta_tutma = null;
        $stoklar_ortalama = null;

        if ($stoklar_bu_ay) {
            $stoklar_onceki_ay = $this->mizanRepository->newQuery()
                ->where('company_id', $company->getId())
                ->where('hesap_kodu', '15')
                ->where('date', '!=', $stoklar_bu_ay->date)
                ->orderByDesc('date')
                ->first();

            if ($stoklar_onceki_ay) {
                $stoklar_ortalama = ($stoklar_onceki_ay->total + $stoklar_bu_ay->total) / 2;
            }
        }

        if ($stoklar_ortalama and $satilan_malin_maliyeti = $this->incomeItemRepository->findBy('hesap_kodu', '621')) {
            $satilan_malin_maliyeti = $this->incomeRepository->newQuery()
                ->where('company_id', $company->getId())
                ->where('item_id', $satilan_malin_maliyeti->getId())
                ->whereRaw('MONTH(date) = ' . $month)
                ->whereRaw('YEAR(date) = ' . $year)
                ->orderByDesc('date')
                ->first();

            $satilan_malin_maliyeti = ($satilan_malin_maliyeti) ? $satilan_malin_maliyeti->total : 0;

            if ($satilan_malin_maliyeti) {
                $calculated_stokta_tutma = $stoklar_ortalama / $satilan_malin_maliyeti * 365;
            }
        }

        return $calculated_stokta_tutma;
    }

    public function getBorcOdemeSuresi($net_satislar, $ortalama_ticari_borclar)
    {
        if ($net_satislar and $ortalama_ticari_borclar) {
            return $ortalama_ticari_borclar / $net_satislar * 365;
        }
        return null;
    }

    public function getNetSatislar($company, $month, $year)
    {
        $net_satislar = null;

        if ($brut_satislar = $this->incomeItemRepository->findBy('hesap_kodu', '60')) {
            $brut_satislar = $this->incomeRepository->newQuery()
                ->where('company_id', $company->getId())
                ->where('item_id', $brut_satislar->getId())
                ->whereRaw('MONTH(date) = ' . $month)
                ->whereRaw('YEAR(date) = ' . $year)
                ->orderByDesc('date')
                ->first();
        }

        $satis_indirimleri = 0;

        if ($satis_indirimleri = $this->incomeItemRepository->findBy('hesap_kodu', '61')) {
            $satis_indirimleri = $this->incomeRepository->newQuery()
                ->where('company_id', $company->getId())
                ->where('item_id', $satis_indirimleri->getId())
                ->whereRaw('MONTH(date) = ' . $month)
                ->whereRaw('YEAR(date) = ' . $year)
                ->orderByDesc('date')
                ->first();

            $satis_indirimleri = ($satis_indirimleri) ? $satis_indirimleri->total : 0;
        }

        if ($brut_satislar) {
            $net_satislar = $brut_satislar->total - $satis_indirimleri;
        }

        return $net_satislar;
    }

    public function getNakitOrani($company, $month, $year, $detail)
    {
        $nakitler = $this->mizanRepository->newQuery()
            ->where('company_id', $company->getId())
            ->where('hesap_kodu', '100')
            ->whereRaw('MONTH(date) = ' . $month)
            ->whereRaw('YEAR(date) = ' . $year)
            ->orderByDesc('date')
            ->first();

        $menkul_kiymetler = $this->mizanRepository->newQuery()
            ->where('company_id', $company->getId())
            ->where('hesap_kodu', '11')
            ->whereRaw('MONTH(date) = ' . $month)
            ->whereRaw('YEAR(date) = ' . $year)
            ->orderByDesc('date')
            ->first();

        if ($nakitler and isset($detail["B"]['total'])) {
            $nakitler = ($nakitler) ? $nakitler->total : 0;
            $menkul_kiymetler = ($menkul_kiymetler) ? $menkul_kiymetler->total : 0;
            $calculated_nakit = ($nakitler || $menkul_kiymetler) ? ($nakitler + $menkul_kiymetler) / $detail["B"]['total'] : null;

            return ($calculated_nakit) ? number_format($calculated_nakit, 2, '.', '') : $calculated_nakit;
        }
        return null;
    }

    public function getStoklarLast($company, $month, $year)
    {
        return $stoklar_bu_ay = $this->mizanRepository->newQuery()
            ->where('company_id', $company->getId())
            ->where('hesap_kodu', '15')
            ->whereRaw('MONTH(date) = ' . $month)
            ->whereRaw('YEAR(date) = ' . $year)
            ->orderByDesc('date')
            ->first();
    }

    public function getLikiditeOran($detail, $last_stoklar)
    {
        if ($last_stoklar and isset($detail["B"]['total']) and isset($detail["A"]['total'])) {
            $stoklar = ($last_stoklar) ? $last_stoklar->total : 0;
            $calculated_likidite = ($detail["A"]['total'] != 0) ? ($detail["A"]['total'] - $stoklar) / $detail["B"]['total'] : null;
            return ($calculated_likidite) ? number_format($calculated_likidite, 2, '.', '') : $calculated_likidite;
        }

        return null;
    }

    public function getCariOran($detail)
    {
        if (isset($detail["A"]['total']) and isset($detail["B"]['total'])) {
            $calculated_cari = ($detail["A"]['total'] != 0) ? $detail["A"]['total'] / $detail["B"]['total'] : null;
            return ($calculated_cari) ? number_format($calculated_cari, 2, '.', '') : $calculated_cari;
        }

        return null;
    }
}
