<?php namespace Visiosoft\PatronModule;

use Anomaly\Streams\Platform\Addon\Module\Module;

class PatronModule extends Module
{

    /**
     * The navigation display flag.
     *
     * @var bool
     */
    protected $navigation = true;

    /**
     * The addon icon.
     *
     * @var string
     */
    protected $icon = 'fa fa-puzzle-piece';

    /**
     * The module sections.
     *
     * @var array
     */
    protected $sections = [
        'import_mizan' => [
            'href' => '/admin/patron/import',
            'title' => ' 1-  Veri Girişi',
            'permission' => false
        ],
        'degerleme' => [
            'href' => '/admin/patron/mizan',
            'title' => ' 2- Değerleme',
            'permission' => false
        ],
        'revizyon' => [
            'href' => '/working-capital-monthly',
            'title' => ' 3- Revizyon',
            'permission' => false
        ],
        'raporlama' => [
            'href' => '/working-capital',
            'title' => ' 4- Raporlama',
            'permission' => false
        ],

        'companies' => [
            'buttons' => [
                'new_company',
            ],
        ],
        'items' => [
            'buttons' => [
                'new_item',
            ],
        ],
        'synonyms' => [
            'buttons' => [
                'new_synonym',
            ],
        ],
        'expenses' => [
            'buttons' => [
                'new_expense',
            ],
        ],
        'analytics' => [
            'buttons' => [
                'new_analytic',
            ],
        ],
        'code_note' => [
            'buttons' => [
                'new_code_note',
            ],
        ]
    ];

}
