<?php namespace Visiosoft\PatronModule\Mizan\Notifications;

use Anomaly\Streams\Platform\Notification\Message\MailMessage;
use Anomaly\UsersModule\User\Contract\UserInterface;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;

class RevisionMessage extends Notification implements ShouldQueue
{

    use Queueable;

    public $message;
    public $to;

    public function __construct($message, $to = null)
    {
        $this->message = $message;
        $this->to = $to;
    }


    public function via(UserInterface $notifiable)
    {
        return ['mail'];
    }

    public function toMail(UserInterface $notifiable)
    {
        if ($this->to != null) {
            $notifiable->email = $this->to;
        }
        return (new MailMessage())
            ->view('streams::notifications.email')
            ->subject("Revision Message")
            ->greeting("Revision Message")
            ->line($this->message);
    }
}
