<?php namespace Visiosoft\PatronModule\Http\Controller\Admin;

use Anomaly\FilesModule\Disk\Contract\DiskRepositoryInterface;
use Anomaly\FilesModule\File\Contract\FileRepositoryInterface;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Anomaly\Streams\Platform\Ui\Breadcrumb\BreadcrumbCollection;
use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use PhpOffice\PhpSpreadsheet\IOFactory;
use Visiosoft\IncomeModule\Income\Contract\IncomeRepositoryInterface;
use Visiosoft\PatronModule\Company\Contract\CompanyRepositoryInterface;
use Visiosoft\PatronModule\Expense\Contract\ExpenseRepositoryInterface;
use Visiosoft\PatronModule\Item\Contract\ItemRepositoryInterface;
use Visiosoft\PatronModule\Mizan\Contract\MizanRepositoryInterface;
use Visiosoft\PatronModule\Mizan\Form\MizanFormBuilder;
use Visiosoft\PatronModule\Mizan\Table\MizanTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\PatronModule\Synonym\Contract\SynonymRepositoryInterface;
use Visiosoft\PatronModule\Traits\PatronTrait;
use SimpleXLSX;

class MizanController extends AdminController
{
    use PatronTrait;

    protected $item_patron;
    protected $item_income;
    protected $company;
    protected $expense;
    protected $synonym_patron_Repository;
    protected $synonym_income_Repository;
    protected $income;
    protected $mizan;

    public function __construct(
        ItemRepositoryInterface $itemPatronRepository,
        CompanyRepositoryInterface $companyRepository,
        MizanRepositoryInterface $mizanRepository,
        ExpenseRepositoryInterface $expenseRepository,
        \Visiosoft\IncomeModule\Synonym\Contract\SynonymRepositoryInterface $synonymIncomeRepository,
        SynonymRepositoryInterface $synonymPatronRepository,
        IncomeRepositoryInterface $incomeRepository,
        \Visiosoft\IncomeModule\Item\Contract\ItemRepositoryInterface $itemIncomeRepository
    )
    {
        $this->item_patron = $itemPatronRepository;
        $this->item_income = $itemIncomeRepository;
        $this->company = $companyRepository;
        $this->mizan = $mizanRepository;
        $this->expense = $expenseRepository;
        $this->synonym_patron_Repository = $synonymPatronRepository;
        $this->synonym_income_Repository = $synonymIncomeRepository;
        $this->income = $incomeRepository;
        parent::__construct();
    }

    /**
     * Display an index of existing entries.
     *
     * @param MizanTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(MizanTableBuilder $table)
    {

        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param MizanFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(MizanFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param MizanFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(MizanFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function import(FormBuilder $builder,
                           FileRepositoryInterface $fileRepository,
                           DiskRepositoryInterface $disks,
                           FolderRepositoryInterface $folders)
    {

        $builder->setOption('breadcrumb', 'Mizan Yükleme');

        $new_breadcrumbs = [
            array_key_first($this->breadcrumbs->toArray()) => $this->breadcrumbs->first(),
            'Çalışma Sermayesi ' => '#',
            array_key_last($this->breadcrumbs->toArray()) => $this->breadcrumbs->last()
        ];

        $company = $this->getActiveCompany();

        $this->breadcrumbs->splice(0, 2);

        foreach ($new_breadcrumbs as $key => $breadcrumb) {
            $this->breadcrumbs->add($key, $breadcrumb);
        }

        if ($company == null) {
            die('Bu kullanıcıya ait şirket bulunmuyor!. Müşteri temsilciniz ile görüşünüz! ');
        }
        //Check Directory or Create Directory
        if (is_null($folders->findBy('slug', 'patron_excel_files'))) {
            $disk = $disks->findBySlug('local');

            $folders->create([
                'en' => [
                    'name' => 'Patron Excel Files',
                    'description' => 'A folder for Patron Excel Files.',
                ],
                'slug' => 'patron_excel_files',
                'disk' => $disk,
            ]);
        };

        //Check Request
        $render = array();

        if (request()->action == "save" and $file = $fileRepository->find(request()->file)) {
            if ($file->extension === 'xlsx' || $file->extension === 'xls') {
                $pathToFolder = "/storage/streams/default/files-module/local/patron_excel_files/";

                $date = ($date = $this->request->get('date') and $date != "") ? $date : now()->format('Y-m-d');


                if ($file->extension === 'xls') {

                    $objPHPExcel = IOFactory::load(base_path() . $pathToFolder . $file->name);

                    $objWriter = IOFactory::createWriter($objPHPExcel, 'Xlsx');

                    $objWriter->save(str_replace('.xls', '.xlsx', strtotime('now') . $file->name));

                    $file_path = public_path(strtotime('now') . $file->name . "x");
                } else {
                    $file_path = base_path() . $pathToFolder . $file->name;
                }

                $xlsx = SimpleXLSX::parse($file_path);
                $xlsx = $xlsx->rowsEx();

                //Search Start Row
                $start_row = 0;
                foreach ($xlsx as $key_row => $row) {
                    foreach ($row as $column) {
                        if ($column['value'] == "100") {
                            $start_row = $key_row;
                            break;
                        }
                    }
                }

                $render = array();
                $column_index = [
                    'hesap_kodu' => '',
                    'hesap_adi' => '',
                    'toplam_borc' => '',
                    'toplam_alacak' => '',
                    'bakiye_borc' => '',
                    'bakiye_alacak' => '',
                ];
                foreach (array_slice($xlsx, $start_row) as $key_row => $row) {

                    //Search Columns Index And Set Keys
                    if ($column_index['toplam_alacak'] == '') {
                        foreach ($row as $column_key => $column) {
                            if ($column['value'] != "" or $column['value'] === 0) {
                                if ($column_index['hesap_kodu'] == '' and $column_index['hesap_kodu'] !== 0) {
                                    $column_index['hesap_kodu'] = $column_key;
                                } elseif ($column_index['hesap_adi'] == '') {
                                    $column_index['hesap_adi'] = $column_key;
                                } elseif ($column_index['toplam_borc'] == "") {
                                    $column_index['toplam_borc'] = $column_key;
                                } elseif ($column_index['toplam_alacak'] == "") {
                                    $column_index['toplam_alacak'] = $column_key;
                                } elseif ($column_index['bakiye_borc'] == "") {
                                    $column_index['bakiye_borc'] = $column_key;
                                } elseif ($column_index['bakiye_alacak'] == "") {
                                    $column_index['bakiye_alacak'] = $column_key;
                                }
                            }
                        }
                    }

                    //Render Data
                    $new_row = array();
                    $new_row['hesap_no'] = $row[$column_index['hesap_kodu']]['value'];
                    $new_row['hesap_adi'] = $row[$column_index['hesap_adi']]['value'];
                    $new_row['toplam_borc'] = $row[$column_index['toplam_borc']]['value'];
                    $new_row['toplam_alacak'] = $row[$column_index['toplam_alacak']]['value'];

                    if ($column_index['bakiye_alacak'] != "" and $column_index['bakiye_borc'] != "") {
                        $new_row['bakiye_borc'] = $row[$column_index['bakiye_borc']]['value'];
                        $new_row['bakiye_alacak'] = $row[$column_index['bakiye_alacak']]['value'];
                    }

                    if ($new_row['hesap_adi'] != "") {
                        $render[] = $new_row;
                    }
                }

            } else {
                $this->messages->error(trans('module::message.support_field_type_error'));
            }

            $company = $this->getActiveCompany();

            if (count($render) and $company) {
                foreach ($render as $item) {
                    $start_number = substr($item['hesap_no'], 0, 1);

                    $expense = (int) $item['toplam_borc'];
                    $income =  (int) $item['toplam_alacak'];
                    $mizan =  (int) $item['toplam_alacak'];
                    if (isset($item['bakiye_alacak'])) {
                        $expense = (int) $item['bakiye_borc'];
                        $income = (int) $item['bakiye_alacak'];
                    }


                    if ($start_number == "7") {//Gider ise
                        //Create Expense Item
                        $item_patron = $this->findSynonyms($item['hesap_adi'], $this->synonym_patron_Repository);
                        if (!$item_patron and !$item_patron = $this->item_patron->findBy('hesap_kodu', $item['hesap_no'])) {
                            $item_patron = $this->item_patron->createNew($item['hesap_adi'], $item['hesap_no']);
                        }

                        if (($expense != 0) AND ($expense != "0,00")) {
                            //Create Expense
                            $this->expense->createNew($item_patron->getId(), $expense, $date, $company->getId());
                        }

                    } else if ($start_number == "6") {//Gelir ise
                        //Create Income Item
                        $item_income = $this->findSynonyms($item['hesap_adi'], $this->synonym_income_Repository);
                        if (!$item_income and !$item_income = $this->item_income->findBy('hesap_kodu', $item['hesap_no'])) {
                            $item_income = $this->item_income->createNew($item['hesap_adi'], $item['hesap_no']);
                        }

                        if (($income != 0) AND ($income != "0,00")) {
                            //Create Income
                            $this->income->createNew($item_income->getId(), $income, $date, $company->getId());
                        }


                    } else if (in_array($start_number, ['1', '3'])) {//1xx , 2xx ve 3xx ise
                        if($expense == 0) {
                            $mizan = $income;
                        }
                        if($income == 0) {
                            $mizan = $expense;
                        }

                        if (($mizan != 0) AND ($mizan != "0,00")) {
                            //Create Mizan
                            $this->mizan->createNew($item['hesap_adi'], $item['hesap_no'], $mizan, $date, $company->getId());
                        }
                    }
                }

                //Ek Cari Varlıklar
                for ($i = 800; $i <= 810; $i++) {
                    $this->mizan->createNew("Manuel bilgi girilecek", $i, 0, $date, $company->getId());
                }

                //Ek Cari Yükümlülükler
                for ($i = 820; $i <= 830; $i++) {
                    $this->mizan->createNew("Manuel bilgi girilecek", $i, 0, $date, $company->getId());
                }


                $this->messages->success(trans('streams::message.create_success', ['name' => trans('module::stream.items.name')]));
            }
            return $this->redirect->route('visiosoft.module.patron::index');
        }
        $builder->setActions(['save' => [
            'text' => 'Mizan Yükle'
        ]]);
        $builder->setFields([
            'file' => [
                "type" => "anomaly.field_type.file",
                "instructions" => "Uygulamayı kullanmaya buradan başlayacaksınız. 
                                    Lütfen bu bölümden ilgii döneme ait mizanı excel formatında giriniz.  
                                    Mizan girişi sırasında dikkat edilecek kurallar şunlardır ; 
                                    <br/> 
     1-  Excel formatı olarak ''XLS'' ve ''XLSX''  uzantıları desteklenmektedir.         
                                         <br/> 

   2-  Excel çalışma sayfasındaki mizanınız altı kolondan oluşmalı ve birebir şu kolon isimlerine sahip olmalıdır ;  
                                       <br/> 
                                    
  &nbsp; &nbsp; Hesap Kodu I Hesap Adı I Borç I Alacak  I  Borç Bakiyesi  I  Alacak Bakiyesi   
      <br/> 
    Bu formata uygun olmayan mizanlar yüklenemez. Lütfen excele çektiğiniz mizanın kolon isimlerini kontrol ediniz. 
     
                                      
                                    <br/>
                                    3- Eğer bu formata uygun olmayan mizana sahipseniz veya yükleme aşamasında sorun yaşıyorsanız
                                     örnek formatı indirerek verileri içine yapıştırabilirsiniz. 
                                     

                                    <a href='https://dijicfo.com/mizan.xls'>
                                    Örnek Dosyayı indir
                                    </a>
                                     <br/> 

                                    <br/>

                                    ",
                "config" => [
                    'folders' => ["patron_excel_files"],
                    'mode' => 'upload'
                ]
            ],
            "date" => [
                "instructions" => "Mizan dönemini lütfen takvimden seçiniz, geçmiş dönemlere ait mizan girişi yapabilirsiniz.",
                "type" => "anomaly.field_type.datetime",
                "config" => [
                    "mode" => "date",
                ]
            ],
        ]);

        return $builder->render();
    }

    public function findSynonyms($name, $repo)
    {
        $all_synonyms = $repo->all()->pluck('synonym', 'id')->all();
        foreach (explode(' ', $name) as $string) {
            if ($search = array_search($string, $all_synonyms)) {
                break;
            }
        }
        if (!$search) {
            return null;
        }
        $item = $repo->find($search);
        return $item->getItem();
    }
}
