<?php namespace Visiosoft\PatronModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\PatronModule\Mizan\Contract\MizanRepositoryInterface;
use Visiosoft\PatronModule\Traits\PatronTrait;

class MizanController extends PublicController
{
    use PatronTrait;

    protected $mizanRepository;

    public function __construct(MizanRepositoryInterface $mizanRepository)
    {
        $this->mizanRepository = $mizanRepository;
        parent::__construct();
    }

    public function index()
    {
        $hesap_kodlari = json_decode(file_get_contents(__DIR__ . "/hesap_kodlari.json"), true);

        $company = $this->getActiveCompany();

        $entry = $this->mizanRepository->newQuery()
            ->where('company_id', $company->getId())
            ->whereRaw('MONTH(date) = ' . $this->request->get('month',now()->format('m')))
            ->get();

        $mizan = array();
        foreach ($entry as $item) {
            $hesap_kodu = $item->hesap_kodu;
            if (in_array(substr($hesap_kodu, 0, 1), [1, 3])) {
                $mizan[substr($hesap_kodu, 0, 1)][substr($hesap_kodu, 0, 2)][substr($hesap_kodu, 0, 3)][$hesap_kodu] = $item;
            }
        }
//        dd($mizan);
        //Calculate Total
        foreach ($mizan as $c1 => $item1) {
            foreach ($item1 as $c2 => $item2) {
                foreach ($item2 as $c3 => $item3) {
                    $total1 = 0;
                    foreach ($item3 as $ttotal1) {
                        $total1 += $ttotal1->total;
                    }

                    $mizan[$c1][$c2][$c3] = [
                        'total' => $total1,
                        'items' => $item3
                    ];
                }

                $total2 = 0;
                foreach ($mizan[$c1][$c2] as $ttotal2) {
                    $total2 += $ttotal2['total'];
                }
                $mizan[$c1][$c2] = [
                    'total' => $total2,
                    'items' => $mizan[$c1][$c2]
                ];
            }
            $total3 = 0;
            foreach ($mizan[$c1] as $ttotal3) {
                $total3 += $ttotal3['total'];
            }
            $mizan[$c1] = [
                'total' => $total3,
                'items' => $mizan[$c1],
            ];
        }

        $mizan[1]['header'] = 'AKTİF (VARLIKLAR)';
        $mizan[3]['header'] = 'PASİF (KAYNAKLAR)';
//        dd($mizan);

        return $this->view->make('module::mizan-analysis', compact('hesap_kodlari', 'company', 'mizan'));
    }
}
