<?php namespace Visiosoft\PatronModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Visiosoft\PatronModule\Analytic\Contract\AnalyticRepositoryInterface;
use Visiosoft\PatronModule\Company\Contract\CompanyRepositoryInterface;
use Visiosoft\PatronModule\Expense\Contract\ExpenseRepositoryInterface;
use Visiosoft\PatronModule\Item\Contract\ItemRepositoryInterface;
use Visiosoft\PatronModule\Traits\PatronTrait;

class ExpensesController extends PublicController
{
    use PatronTrait;

    private $expenseRepository;
    private $itemRepository;
    private $analyticRepository;
    private $companyRepository;

    public function __construct(
        ExpenseRepositoryInterface $expenseRepository,
        ItemRepositoryInterface $itemRepository,
        CompanyRepositoryInterface $companyRepository,
        AnalyticRepositoryInterface $analyticRepository
    )
    {
        parent::__construct();
        $this->expenseRepository = $expenseRepository;
        $this->itemRepository = $itemRepository;
        $this->companyRepository = $companyRepository;
        $this->analyticRepository = $analyticRepository;
    }

    public function detail($id)
    {
        $analytics = $this->getIncomeOrExpenseAnalytics($this->expenseRepository);

        return $this->view->make(
            'visiosoft.theme.patron::views/expenses/index', [
                'analytics' => $analytics,
            ]
        );
    }

    public function expenseAnalysis()
    {
        //Get Company
        $company = $this->getActiveCompany();

        //Get Items
        $items = $this->itemRepository->newQuery()
            ->where('hesap_kodu', 'like', '7%')
            ->get()->pluck('id', 'name')->all();


        if (count($items) and $company) {
            //added last 3 Month
            foreach ($items as $item_name => $item) {
                $month = array();
                for ($i = -2; $i <= -1; $i++) {
                    $key = date('m', strtotime("$i month", strtotime(date("Y-m-15"))));
                    $month[$key] = [];
                }
                $month[now()->format('m')] = [];

                $items[$item_name] = ['months' => $month];
                $items[$item_name]['item_id'] = $item;
            }

            //added last 3 Year
            foreach ($items as $item_name => $item) {
                $years = array();
                for ($i = -2; $i <= -1; $i++) {
                    $key = date('Y', strtotime("$i year", strtotime(date("Y-m-15"))));
                    $years[$key] = [];
                }
                $years[now()->format('Y')] = [];

                $items[$item_name]['years'] = $years;
            }

            //Get Expenses for Monthly
            foreach ($items as $item_name => $item) {
                $item_id = $item['item_id'];
                //add month rows
                foreach ($item['months'] as $month => $month_value) {
                    $expense_month = $this->expenseRepository->newQuery()
                        ->select(DB::raw('SUM(total) as total,item_id,date'))
                        ->where('item_id', $item_id)
                        ->where('company_id', $company->getId())
                        ->whereRaw('MONTH(date) = ' . $month)
                        ->first();

                    $items[$item_name]['months'][$month]['total'] = $expense_month->total;
                }

                //add year rows
                foreach ($item['years'] as $year => $year_value) {
                    $expense_year = $this->expenseRepository->newQuery()
                        ->select(DB::raw('SUM(total) as total,item_id,date'))
                        ->where('item_id', $item_id)
                        ->where('company_id', $company->getId())
                        ->whereRaw('YEAR(date) = ' . $year)
                        ->first();

                    $items[$item_name]['years'][$year]['total'] = $expense_year->total;
                }
            }

            //Calculate Total
            $total = ['month' => [], 'year' => []];
            foreach ($items as $item) {
                if (isset($item['months'])) {
                    foreach ($item['months'] as $month => $month_values) {
                        if (!isset($total['month'][$month])) {
                            $total['month'][$month] = 0;
                        }
                        $total['month'][$month] += $month_values['total'];
                    }
                }
                if (isset($item['years'])) {
                    foreach ($item['years'] as $year => $year_values) {
                        if (!isset($total['year'][$year])) {
                            $total['year'][$year] = 0;
                        }
                        $total['year'][$year] += $year_values['total'];
                    }
                }
            }


            //calculate percentage
            foreach ($items as $item_name => $item_values) {
                if (isset($item_values['months'])) {
                    foreach ($item_values['months'] as $month => $month_values) {
                        //convert null to zero
                        $price = $items[$item_name]['months'][$month]['total'];
                        $items[$item_name]['months'][$month]['total'] = (is_null($price)) ? 0 : $price;

                        $percentage_rate = ($month_values['total'] * 100) / $total['month'][$month];
                        $percentage_rate = number_format($percentage_rate, 2);
                        $items[$item_name]['months'][$month]['percentage_rate'] = '%' . $percentage_rate;
                    }
                }
                if ($item_values['years']) {
                    foreach ($item_values['years'] as $year => $year_values) {
                        //convert null to zero
                        $price = $items[$item_name]['years'][$year]['total'];
                        $items[$item_name]['years'][$year]['total'] = (is_null($price)) ? 0 : $price;


                        $percentage_rate = ($total['year'][$year] == 0) ? 0 : ($year_values['total'] * 100) / $total['year'][$year];
                        $percentage_rate = number_format($percentage_rate, 2);
                        $items[$item_name]['years'][$year]['percentage_rate'] = '%' . $percentage_rate;
                    }
                }
            }
        }
        return $this->view->make('module::expense-analysis', compact('items', 'total', 'company'));
    }
}
