<?php namespace Visiosoft\PatronModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\PatronModule\Analytic\Contract\AnalyticRepositoryInterface;
use Visiosoft\PatronModule\Analytic\AnalyticRepository;
use Anomaly\Streams\Platform\Model\Patron\PatronAnalyticsEntryModel;
use Visiosoft\PatronModule\Analytic\AnalyticModel;
use Visiosoft\PatronModule\Debt\Contract\DebtRepositoryInterface;
use Visiosoft\PatronModule\Debt\DebtModel;
use Visiosoft\PatronModule\Debt\DebtRepository;
use Visiosoft\PatronModule\Expense\Contract\ExpenseRepositoryInterface;
use Visiosoft\PatronModule\Expense\ExpenseRepository;
use Anomaly\Streams\Platform\Model\Patron\PatronExpensesEntryModel;
use Visiosoft\PatronModule\Expense\ExpenseModel;
use Visiosoft\PatronModule\Item\Contract\ItemRepositoryInterface;
use Visiosoft\PatronModule\Item\ItemRepository;
use Anomaly\Streams\Platform\Model\Patron\PatronItemsEntryModel;
use Visiosoft\PatronModule\Item\ItemModel;
use Visiosoft\PatronModule\Company\Contract\CompanyRepositoryInterface;
use Visiosoft\PatronModule\Company\CompanyRepository;
use Anomaly\Streams\Platform\Model\Patron\PatronCompaniesEntryModel;
use Visiosoft\PatronModule\Company\CompanyModel;

class PatronModuleServiceProvider extends AddonServiceProvider
{

    protected $plugins = [
        PatronModulePlugin::class
    ];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/patron/analytics'           => 'Visiosoft\PatronModule\Http\Controller\Admin\AnalyticsController@index',
        'admin/patron/analytics/create'    => 'Visiosoft\PatronModule\Http\Controller\Admin\AnalyticsController@create',
        'admin/patron/analytics/edit/{id}' => 'Visiosoft\PatronModule\Http\Controller\Admin\AnalyticsController@edit',

        'admin/patron/expenses'           => 'Visiosoft\PatronModule\Http\Controller\Admin\ExpensesController@index',
        'admin/patron/expenses/create'    => 'Visiosoft\PatronModule\Http\Controller\Admin\ExpensesController@create',
        'admin/patron/expenses/edit/{id}' => 'Visiosoft\PatronModule\Http\Controller\Admin\ExpensesController@edit',
        'admin/patron/expenses/view-analytics/{id}' => 'Visiosoft\PatronModule\Http\Controller\Admin\ExpensesController@viewAnalytics',

        'admin/patron/items'           => 'Visiosoft\PatronModule\Http\Controller\Admin\ItemsController@index',
        'admin/patron/items/create'    => 'Visiosoft\PatronModule\Http\Controller\Admin\ItemsController@create',
        'admin/patron/items/edit/{id}' => 'Visiosoft\PatronModule\Http\Controller\Admin\ItemsController@edit',

        'admin/patron'           => 'Visiosoft\PatronModule\Http\Controller\Admin\CompaniesController@index',
        'admin/patron/create'    => 'Visiosoft\PatronModule\Http\Controller\Admin\CompaniesController@create',
        'admin/patron/edit/{id}' => 'Visiosoft\PatronModule\Http\Controller\Admin\CompaniesController@edit',

//        Debts & Receivables Admin
        'admin/patron/debts-and-receivables' => 'Visiosoft\PatronModule\Http\Controller\Admin\DebtController@index',
        'admin/patron/debts-and-receivables/create' => 'Visiosoft\PatronModule\Http\Controller\Admin\DebtController@create',
        'admin/patron/debts-and-receivables/edit/{id}' => 'Visiosoft\PatronModule\Http\Controller\Admin\DebtController@edit',

//        Debts & Receivables
        'debts' =>[
            'as' => 'visiosoft.module.patron::debts',
            'uses' =>  'Visiosoft\PatronModule\Http\Controller\DebtController@debts',
        ],

        'expenses' => [
            'middleware' => 'auth',
            'uses' => 'Visiosoft\PatronModule\Http\Controller\ExpensesController@index',
        ],
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        PatronAnalyticsEntryModel::class => AnalyticModel::class,
        PatronExpensesEntryModel::class => ExpenseModel::class,
        PatronItemsEntryModel::class => ItemModel::class,
        PatronCompaniesEntryModel::class => CompanyModel::class,
        PatronDebtEntryModel::class => DebtModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        AnalyticRepositoryInterface::class => AnalyticRepository::class,
        ExpenseRepositoryInterface::class => ExpenseRepository::class,
        ItemRepositoryInterface::class => ItemRepository::class,
        CompanyRepositoryInterface::class => CompanyRepository::class,
        DebtRepositoryInterface::class => DebtRepository::class,
    ];

}
