<?php namespace Visiosoft\PatronModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Visiosoft\PatronModule\Debt\Contract\DebtRepositoryInterface;

class DebtController extends ResourceController
{
    protected $debtRepository;

    public function __construct(DebtRepositoryInterface $debtRepository)
    {
        $this->debtRepository = $debtRepository;
        parent::__construct();
    }

    public function debts()
    {
        $receivables = $this->debtRepository->getCompanies();
        return $this->view->make('module::debts', compact('receivables'));
    }

}
