<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModulePatronCreateDebtStream extends Migration
{

    protected $delete = false;

    protected $stream = [
        'slug' => 'debt',
        'title_column' => 'type',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    protected $fields = [
        'price' => [
            'type' => 'visiosoft.field_type.decimal',
            'config' => [
                'decimal' => 2,
                'separator' => '.',
                'point' => ','
            ],
        ],
        'company' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\PatronModule\Company\CompanyModel::class
            ],
        ],
        'type' => [
            'type' => 'anomaly.field_type.select',
            'config' => [
                "options" => [
                    'debt' => 'visiosoft.module.patron::field.debt.name',
                    'receivable' => 'visiosoft.module.patron::field.receivable.name'
                ],
                'default_value' => 'debt'
            ],
        ],
        'currency' => [
            'type' => 'anomaly.field_type.select',
            'config' => [
                "options" => [
                    'USD' => 'visiosoft.module.patron::field.USD',
                    'TRY' => 'visiosoft.module.patron::field.TRY',
                    'EUR' => 'visiosoft.module.patron::field.EUR'
                ],
                'default_value' => 'TRY'
            ],
        ],
        'expiry_date' => 'anomaly.field_type.datetime',
    ];

    protected $assignments = [
        'company' => [
            'required' => true,
        ],
        'type' => [
            'required' => true,
        ],
        'price' => [
            'required' => true,
        ],
        'currency' => [
            'required' => true,
        ],
        'expiry_date' => [
            'required' => true,
        ],
    ];
}
