<?php namespace Visiosoft\PatronModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Carbon\Carbon;
use Visiosoft\PatronModule\Mizan\Contract\MizanRepositoryInterface;
use Visiosoft\PatronModule\Traits\PatronTrait;

class HomeController extends PublicController
{
    use PatronTrait;

    protected $mizanRepository;

    public function __construct(MizanRepositoryInterface $mizanRepository)
    {
        $this->mizanRepository = $mizanRepository;
        parent::__construct();
    }

    public function index()
    {
        return $this->view->make('visiosoft.theme.patron::layouts/default');
    }

    public function workingCapitalMonthly()
    {
        $company = $this->getActiveCompany();

        $now = now();
        $month = $now->format('m');
        $year = $now->format('Y');

        //last record
        if ($last_date = $this->mizanRepository->newQuery()->select(['date'])->orderByDesc('date')->first()) {
            $last_date = $last_date->date;
            $month = $last_date->format('m');
            $year = $last_date->format('Y');
        }

        //filter record
        if ($this->request->has('date')) {
            $date = explode('-', $this->request->get('date'));

            $month = end($date);
            $year = array_first($date);
        }


        $entries = $this->mizanRepository->newQuery()
            ->where('company_id', $company->getId())
            ->whereRaw('LENGTH(hesap_kodu) < 4 AND LENGTH(hesap_kodu) > 2')
            ->whereRaw('MONTH(date) = ' . $month)
            ->whereRaw('YEAR(date) = ' . $year)
            ->get();

        $formatted_entries = array();
        foreach ($entries as $entry) {
            $formatted_entries[$entry->hesap_kodu] = $entry->toArray();
        }

        $main_groups = json_decode(file_get_contents(__DIR__ . "/calisma_sermayesi.json"), true);

        $details = array();

        foreach ($main_groups as $main_key => $main_group) {
            $details[$main_key]['name'] = $main_group['name'];
            $details[$main_key]['total_title'] = $main_group['total_title'];
            if (!isset($details[$main_key]['total'])) {
                $details[$main_key]['total'] = 0;
            }
            if (!isset($details[$main_key]['real_value'])) {
                $details[$main_key]['real_value'] = 0;
            }
            foreach ($main_group as $sub_key => $sub_group) {
                if (!isset($details[$main_key]['total'])) {
                    $details[$main_key]['total'] = 0;
                }
                if (!isset($details[$main_key]['real_value'])) {
                    $details[$main_key]['real_value'] = 0;
                }
                if (is_array($sub_group)) {
                    foreach ($sub_group as $index => $item) {
                        if (!isset($details[$main_key][$sub_key]['total'])) {
                            $details[$main_key][$sub_key]['total'] = 0;
                        }
                        if (!isset($details[$main_key][$sub_key]['real_value'])) {
                            $details[$main_key][$sub_key]['real_value'] = 0;
                        }
                        if (array_key_exists($index, $formatted_entries)) {
                            $difference = ($formatted_entries[$index]['real_value'] and $formatted_entries[$index]['real_value'] > 0) ? $formatted_entries[$index]['total'] - $formatted_entries[$index]['real_value'] : 0;
                            $formatted_entries[$index]['minus'] = ($difference > 0) ? $difference : 0;
                            $formatted_entries[$index]['plus'] = ($difference < 0) ? $difference : 0;
                            $details[$main_key][$sub_key]['total'] = $details[$main_key][$sub_key]['total'] + $formatted_entries[$index]['total'];
                            $details[$main_key][$sub_key]['real_value'] = $details[$main_key][$sub_key]['real_value'] + $formatted_entries[$index]['real_value'];
                            $details[$main_key][$sub_key][$index] = $formatted_entries[$index];

                            $difference_group = ($details[$main_key][$sub_key]['real_value'] and $details[$main_key][$sub_key]['real_value'] > 0) ? $details[$main_key][$sub_key]['total'] - $details[$main_key][$sub_key]['real_value'] : 0;
                            $details[$main_key][$sub_key]['minus'] = ($difference_group > 0) ? $difference_group : 0;
                            $details[$main_key][$sub_key]['plus'] = ($difference_group < 0) ? $difference_group : 0;
                        }
                    }
                    $details[$main_key][$sub_key]['name'] = $main_group[$sub_key]['name'];

                    $details[$main_key]['total'] = $details[$main_key]['total'] + $details[$main_key][$sub_key]['total'];
                    $details[$main_key]['real_value'] = $details[$main_key]['real_value'] + $details[$main_key][$sub_key]['real_value'];

                    $difference_main = ($details[$main_key]['real_value'] and $details[$main_key]['real_value'] > 0) ? $details[$main_key]['total'] - $details[$main_key]['real_value'] : 0;
                    $details[$main_key]['minus'] = ($difference_main > 0) ? $difference_main : 0;
                    $details[$main_key]['plus'] = ($difference_main < 0) ? $difference_main : 0;
                }

            }
        }

        return $this->view->make('visiosoft.module.patron::working-capital-monthly', compact('details', 'main_groups', 'company', 'month', 'year'));
    }

    public function workingCapital()
    {
        $company = $this->getActiveCompany();

        $last_date = $this->mizanRepository->newQuery()->select(['date'])->orderByDesc('date')->first();
        $first_date = $this->mizanRepository->newQuery()->select(['date'])->orderBy('date', 'ASC')->first();

        if (!$last_date and !$first_date) {
            abort(404);
        }
        $start_date = new Carbon('2020-03-01');
        $finish_date = new Carbon('2021-05-03');

        $months = [$start_date->format('m-Y')];

        while ($start_date <= $finish_date) {
            $start_date = $start_date->addMonths(1);
            $months[] = $start_date->format('m-Y');
        }


        $main_groups = json_decode(file_get_contents(__DIR__ . "/calisma_sermayesi.json"), true);

        $details = array();

        foreach ($main_groups as $main_key => $main_group) {
            $details[$main_key]['name'] = $main_group['name'];
            foreach ($main_group as $sub_key => $sub_group) {
                if (is_array($sub_group)) {
                    foreach ($sub_group as $index => $item) {
                        if ($index !== "name") {
                            foreach ($months as $month) {
                                $date = explode('-', $month);
                                if (!isset($details[$main_key][$sub_key]['child'][$month])) {
                                    $details[$main_key][$sub_key]['child'][$month] = 0;
                                }

                                $entries = $this->mizanRepository->newQuery()
                                    ->where('company_id', $company->getId())
                                    ->where('hesap_kodu', $index)
                                    ->whereRaw('MONTH(date) = ' . array_first($date))
                                    ->whereRaw('YEAR(date) = ' . end($date))
                                    ->orderByDesc('date')
                                    ->first();

                                $total = ($entries) ? $entries->total : 0;
                                $details[$main_key][$sub_key]['child'][$month] = $details[$main_key][$sub_key]['child'][$month] + $total;


                                $details[$main_key][$sub_key]['items'][$index]['name'] = $item;
                                $details[$main_key][$sub_key]['items'][$index][$month] = ($entries) ? $entries->total : 0;
                            }
                        } else {
                            $details[$main_key][$sub_key][$index] = $item;
                        }
                    }
                }
            }
        }

        //Rander Years
        $years = [];
        foreach ($months as $month) {
            $year = new Carbon("01-" . $month);
            $year = $year->format('Y');
            if (!isset($years[$year])) {
                $years[$year] = 0;
            }
            $years[$year] += 1;
        }

        //Calculate Total
        $total = array();
        foreach ($details as $main_key => $main) {
            if (is_array($main)) {
                foreach ($main as $sub_key => $sub) {
                    if (is_array($sub)) {
                        foreach ($sub['child'] as $item_key => $item) {
                            if (!isset($total[$main_key][$item_key])) {
                                $total[$main_key][$item_key] = 0;
                            }
                            if (!isset($total[$item_key])) {
                                $total[$item_key] = 0;
                            }
                            $total[$main_key][$item_key] += $item;
                            $total[$item_key] += $item;
                        }
                    }

                }
            }

        }


//        dd($details, $months, $total);

        return $this->view->make('visiosoft.module.patron::working-capital', compact('details', 'company', 'months', 'years', 'total'));
    }
}
