<?php namespace Visiosoft\PatronModule\Http\Controller\Admin;

use Anomaly\FilesModule\Disk\Contract\DiskRepositoryInterface;
use Anomaly\FilesModule\File\Contract\FileRepositoryInterface;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Illuminate\Support\Str;
use SimpleXLSX;
use Visiosoft\IncomeModule\Income\Contract\IncomeRepositoryInterface;
use Visiosoft\IncomeModule\Synonym\SynonymRepository;
use Visiosoft\PatronModule\Company\Contract\CompanyRepositoryInterface;
use Visiosoft\PatronModule\Company\Form\CompanyFormBuilder;
use Visiosoft\PatronModule\Company\Table\CompanyTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\PatronModule\Expense\Contract\ExpenseRepositoryInterface;
use Visiosoft\PatronModule\Item\Contract\ItemRepositoryInterface;
use Visiosoft\PatronModule\Synonym\Contract\SynonymRepositoryInterface;

class CompaniesController extends AdminController
{
    protected $item_patron;
    protected $item_income;
    protected $company;
    protected $exponse;
    protected $synonym_patron_Repository;
    protected $synonym_income_Repository;
    protected $income;

    public function __construct(
        ItemRepositoryInterface $itemPatronRepository,
        CompanyRepositoryInterface $companyRepository,
        ExpenseRepositoryInterface $expenseRepository,
        \Visiosoft\IncomeModule\Synonym\Contract\SynonymRepositoryInterface $synonymIncomeRepository,
        SynonymRepositoryInterface $synonymPatronRepository,
        IncomeRepositoryInterface $incomeRepository,
        \Visiosoft\IncomeModule\Item\Contract\ItemRepositoryInterface $itemIncomeRepository
    )
    {
        $this->item_patron = $itemPatronRepository;
        $this->item_income = $itemIncomeRepository;
        $this->company = $companyRepository;
        $this->exponse = $expenseRepository;
        $this->synonym_patron_Repository = $synonymPatronRepository;
        $this->synonym_income_Repository = $synonymIncomeRepository;
        $this->income = $incomeRepository;
        parent::__construct();
    }

    /**
     * Display an index of existing entries.
     *
     * @param CompanyTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(CompanyTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param CompanyFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(CompanyFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param CompanyFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(CompanyFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function import(FormBuilder $builder,
                           FileRepositoryInterface $fileRepository,
                           DiskRepositoryInterface $disks,
                           FolderRepositoryInterface $folders)
    {

        //Check Directory or Create Directory
        if (is_null($folders->findBy('slug', 'patron_excel_files'))) {
            $disk = $disks->findBySlug('local');

            $folders->create([
                'en' => [
                    'name' => 'Patron Excel Files',
                    'description' => 'A folder for Patron Excel Files.',
                ],
                'slug' => 'patron_excel_files',
                'disk' => $disk,
                'allowed_types' => [
                    'xls', 'xlsx',
                ],
            ]);
        };

        //Check Request
        if (request()->action == "save" and $file = $fileRepository->find(request()->file)) {
            if ($file->extension === 'xls' || $file->extension === 'xlsx') {
                $pathToFolder = "/storage/streams/default/files-module/local/patron_excel_files/";

                //Parse Data
                $xlsx = SimpleXLSX::parse(base_path() . $pathToFolder . $file->name);
                $xlsx = $xlsx->rowsEx();

                //Render Company
                $company_name = $xlsx[1][5]['value'];

                //Render Row
                $render = array();
                $toplam = array();
                foreach (array_slice($xlsx, 20) as $row) {
                    $new_row = array();
                    if ($row[14]['value'] != "" or $row[10]['value'] != "" or $row[19]['value'] != "" or $row[24]['value'] != "") {
                        if ($row[1]['value'] == "") {
                            $new_row['toplam_borc'] = $row[10]['value'];
                            $new_row['toplam_alacak'] = $row[14]['value'];
                            $new_row['bakiye_borc'] = $row[19]['value'];
                            $new_row['bakiye_alacak'] = $row[24]['value'];
                            $toplam = $new_row;

                        } else {
                            //Sadece Giderler
                            if (substr($row[1]['value'], 0, 1) == 7) {
                                $new_row['hesap_no'] = $row[1]['value'];
                                $new_row['hesap_adi'] = $row[7]['value'];
                                $new_row['toplam_borc'] = $row[10]['value'];
                                $new_row['toplam_alacak'] = $row[14]['value'];
                                $new_row['bakiye_borc'] = $row[19]['value'];
                                $new_row['bakiye_alacak'] = $row[24]['value'];
                                $render[] = $new_row;
                            }
                        }
                    }

                }
            }
            if (count($render)) {
                if (!$company = $this->company->findBy('slug', Str::slug($company_name, '_'))) {
                    $company = $this->company->createCompany($company_name);
                }

                foreach ($render as $item) {
                    $item_patron = $this->findSynonyms($item['hesap_adi'], $this->synonym_patron_Repository);
                    //Borç
                    if (!$item_patron and !$item_patron = $this->item_patron->findBy('name', $item['hesap_adi'])) {
                        $item_patron = $this->item_patron->createNew($item['hesap_adi'], $item['hesap_no']);
                    }
                    $this->exponse->createNew($item_patron->getId(), $item['bakiye_borc'], now(), $company->getId());

                    //Alacak
                    $item_income = $this->findSynonyms($item['hesap_adi'], $this->synonym_income_Repository);

                    if (!$item_income and !$item_income = $this->item_income->findBy('name', $item['hesap_adi'])) {
                        $item_income = $this->item_income->createNew($item['hesap_adi'], $item['hesap_no']);
                    }
                    $this->income->createNew($item_income->getId(), $item['bakiye_alacak'], now());
                }
            }
            $this->messages->success(trans('streams::message.create_success', ['name' => trans('module::stream.items.name')]));
            return $this->redirect->route('visiosoft.module.patron::index');
        }
        $builder->setActions(['save']);
        $builder->setFields([
            'file' => [
                "type" => "anomaly.field_type.file",
                "config" => [
                    'folders' => ["patron_excel_files"],
                    'mode' => 'upload'
                ]
            ],
        ]);
        return $builder->render();
    }

    public function findSynonyms($name, $repo)
    {
        $all_synonyms = $repo->all()->pluck('synonym', 'id')->all();
        foreach (explode(' ', $name) as $string) {
            if ($search = array_search($string, $all_synonyms)) {
                break;
            }
        }
        if (!$search) {
            return null;
        }
        $item = $repo->find($search);
        return $item->getItem();
    }
}
