<?php namespace Visiosoft\PatronModule\Http\Controller\Admin;

use Anomaly\FilesModule\Disk\Contract\DiskRepositoryInterface;
use Anomaly\FilesModule\File\Contract\FileRepositoryInterface;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Illuminate\Support\Str;
use SimpleXLSX;
use Visiosoft\PatronModule\Company\Contract\CompanyRepositoryInterface;
use Visiosoft\PatronModule\Debt\Contract\DebtRepositoryInterface;
use Visiosoft\PatronModule\Debt\Form\DebtFormBuilder;
use Visiosoft\PatronModule\Debt\Table\DebtTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class DebtController extends AdminController
{

    public function index(DebtTableBuilder $table)
    {
        return $table->render();
    }

    public function create(DebtFormBuilder $form)
    {
        return $form->render();
    }

    public function edit(DebtFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function import(FormBuilder $builder,
                           FileRepositoryInterface $fileRepository,
                           DebtRepositoryInterface $debtRepository,
                           CompanyRepositoryInterface $companyRepository,
                           DiskRepositoryInterface $disks,
                           FolderRepositoryInterface $folders)
    {

        //Check Directory or Create Directory
        if (is_null($folders->findBy('slug', 'patron_excel_files'))) {
            $disk = $disks->findBySlug('local');

            $folders->create([
                'en' => [
                    'name' => 'Patron Excel Files',
                    'description' => 'A folder for Patron Excel Files.',
                ],
                'slug' => 'patron_excel_files',
                'disk' => $disk,
                'allowed_types' => [
                    'xls', 'xlsx',
                ],
            ]);
        };

        //Check Request
        if (request()->action == "save" and $file = $fileRepository->find(request()->file)) {
            if ($file->extension === 'xls' || $file->extension === 'xlsx') {
                $pathToFolder = "/storage/streams/default/files-module/local/patron_excel_files/";

                //Parse Data
                $xlsx = SimpleXLSX::parse(base_path() . $pathToFolder . $file->name);
                $values = [];
                foreach ($xlsx->rows() as $k => $r) {
                    if ($k === 0) {
                        $values = $r;
                        continue;
                    }
                    $debts[] = array_combine($values, $r);
                }
            }
            if (count($debts)) {
                //Delete Old
                $debtRepository->newQuery()->delete();
                foreach ($debts as $debt) {
                    if (!$company = $companyRepository->searchByName($debt['name'])) {
                        $company = $companyRepository->createCompany($debt['name']);
                    }
                    //Create New Record
                    $debtRepository->createDebt($company->getId(), $debt['type'], $debt['price'], $debt['currency'], $debt['expiry_date']);
                }
            }
            $this->messages->success(trans('streams::message.create_success', ['name' => trans('module::section.debts_and_receivables.title')]));
            return $this->redirect->route('visiosoft.module.debts::index');
        }
        $builder->setActions(['save']);
        $builder->setFields([
            'file' => [
                "type" => "anomaly.field_type.file",
                "config" => [
                    'folders' => ["patron_excel_files"],
                    'mode' => 'upload'
                ]
            ],
        ]);
        return $builder->render();
    }
}
