<?php namespace Visiosoft\PatronModule\Debt\Form;

use Visiosoft\PatronModule\Debt\DebtModel;

class DebtFormSections
{
    public function handle(DebtFormBuilder $builder, DebtModel $debtModel)
    {
        $fields = [
            'company',
            'type',
            'price',
            'currency',
            'expiry_date'
        ];


        $assignments = $debtModel->getAssignments();

        $otherFields = $assignments->notLocked()->fieldSlugs();

        $builder->setSections(
            [
                'user' => [
                    'tabs' =>
                        function () use ($fields, $otherFields) {
                            $sections = [
                                'store' => [
                                    'title' => 'visiosoft.module.patron::tab.general',
                                    'fields' => $fields,
                                ],
                            ];

                            if (count($otherFields)) {
                                $sections = array_merge($sections, [
                                    'other' => [
                                        'title' => 'visiosoft.module.patron::tab.other',
                                        'fields' => $otherFields,
                                    ],
                                ]);
                            }
                            return $sections;
                        },
                ],
            ]
        );
    }
}
