<?php namespace Visiosoft\PatronModule\Company;

use Illuminate\Support\Str;
use Visiosoft\PatronModule\Company\Contract\CompanyRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class CompanyRepository extends EntryRepository implements CompanyRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var CompanyModel
     */
    protected $model;

    /**
     * Create a new CompanyRepository instance.
     *
     * @param CompanyModel $model
     */
    public function __construct(CompanyModel $model)
    {
        $this->model = $model;
    }

    public function searchByName($keyword)
    {
        return $this->newQuery()->where('slug', 'like', '%' . $keyword . '%')->first();
    }

    public function createCompany($name)
    {
        return $this->create([
            'name' => $name,
            'slug' => Str::slug($name)
        ]);
    }
}
