<?php namespace Visiosoft\PatronModule;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Twig_Environment;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Adv\Command\appendRequestURL;
use Visiosoft\AdvsModule\Adv\Command\GetAd;
use Visiosoft\AdvsModule\Adv\Command\getPopular;
use Visiosoft\AdvsModule\Adv\Command\GetUserAds;
use Visiosoft\AdvsModule\Adv\Command\isActive;
use Visiosoft\AdvsModule\Adv\Command\LatestAds;
use Visiosoft\AdvsModule\Currency\Currency;
use Visiosoft\AdvsModule\Currency\CurrencyFormat;

class PatronModulePlugin extends Plugin
{

    /**
     * @return array
     */
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction(
                'calculateCompanyTotal',
                function ($total, $key, $value) {
                    if(!array_key_exists($key,$total))
                    {
                        $total[$key] = 0;
                    }
                    $total[$key] = $total[$key] + $value;
                    return $total;
                }
            )
        ];
    }
}
