<?php namespace Visiosoft\PatronModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\PatronModule\Analytic\Contract\AnalyticRepositoryInterface;
use Visiosoft\PatronModule\Expense\Contract\ExpenseRepositoryInterface;
use Visiosoft\PatronModule\Traits\PatronTrait;

class ExpensesController extends PublicController
{
    use PatronTrait;

    private $expenseRepository;
    private $analyticRepository;

    public function __construct(
        ExpenseRepositoryInterface $expenseRepository,
        AnalyticRepositoryInterface $analyticRepository
    )
    {
        parent::__construct();
        $this->expenseRepository = $expenseRepository;
        $this->analyticRepository = $analyticRepository;
    }

    public function index()
    {
        $analytics = $this->getIncomeOrExpenseAnalytics($this->expenseRepository);

        return $this->view->make(
            'visiosoft.theme.patron::views/expenses/index', [
                'analytics'  => $analytics,
            ]
        );
    }
}
