<?php namespace Visiosoft\PatronModule\Http\Controller\Admin;

use Visiosoft\PatronModule\Synonym\Form\SynonymFormBuilder;
use Visiosoft\PatronModule\Synonym\Table\SynonymTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class SynonymsController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param SynonymTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(SynonymTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param SynonymFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(SynonymFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param SynonymFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(SynonymFormBuilder $form, $id)
    {
        return $form->render($id);
    }
}
