<?php namespace Visiosoft\PatronModule\Expense\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class ExpenseTableBuilder extends TableBuilder
{

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'item',
        'total',
        'date' => [
            'value' => "entry.date.format('M Y')",
        ],
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'view_analytics' => [
            'type' => 'info',
            'href' => 'admin/patron/expenses/view-analytics/{entry.id}',
        ],
        'edit',
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete'
    ];

}
