<?php namespace Visiosoft\PatronModule\Mizan\Form;

use Visiosoft\PatronModule\Mizan\Contract\MizanRepositoryInterface;

class MizanFormHandler
{
    public function handle(MizanFormBuilder $builder, MizanRepositoryInterface $repository)
    {
        if (!$builder->canSave()) {
            return;
        }

        $builder->saveForm();

        $entry = $builder->getFormEntry();

        $hesap_kodu_tree = explode('.', $entry->hesap_kodu);

        $entry_code = "";
        foreach ($hesap_kodu_tree as $index => $hesap_kodu) {
            if (count($hesap_kodu_tree) - 1 > $index) {
                $entry_code .= $hesap_kodu;
                $parent = $repository->newQuery()
                    ->where('company_id', $entry->company_id)
                    ->where('date', $entry->date)
                    ->where('hesap_kodu', $entry_code)
                    ->first();

                if ($parent) {
                    $parent->update([
                        'real_value' => $parent->real_value + ($entry->real_value - $entry->total)
                    ]);
                }
                $entry_code .= ".";
            }
        }
    }

}
