<?php namespace Visiosoft\PatronModule;

use Anomaly\PostsModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Support\Str;
use Visiosoft\PatronModule\Debt\Contract\DebtRepositoryInterface;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;

class PatronModuleSeeder extends Seeder
{
    protected $types;

    protected $fields;

    protected $streams;

    protected $debtRepository;

    protected $assignments;

    public function __construct(
        TypeRepositoryInterface $types,
        FieldRepositoryInterface $fields,
        StreamRepositoryInterface $streams,
        DebtRepositoryInterface $debtRepository,
        AssignmentRepositoryInterface $assignments
    )
    {
        $this->types = $types;
        $this->fields = $fields;
        $this->debtRepository = $debtRepository;
        $this->streams = $streams;
        $this->assignments = $assignments;
    }

    public function run()
    {

        //Assign Fields
        $stream = $this->streams->findBySlugAndNamespace('debt', 'patron');
        $fields = [
            [
                'name' => 'Debt Category',
                'slug' => 'debt_category',
                'type' => 'anomaly.field_type.select',
                'namespace' => 'patron',
                'config' => [
                    'options' => "1: Satıcı\n2: Vergi\n3: SGK\n4: Personel\n5: Banka\n6: Leasing\n7: Diğer\n8: Ortaklar\n9: Avans",
                ]
            ],
            [
                'name' => 'Receivable Category',
                'slug' => 'receivable_category',
                'type' => 'anomaly.field_type.select',
                'namespace' => 'patron',
                'config' => [
                    'options' => "1: Alıcılar\n2: Kamu / Vergi / SGK\n3: Teşvik\n4: Personel\n5: Ortaklar\n6: Diğer\n7: Avans",
                ]
            ]
        ];


        foreach ($fields as $item) {
            if (!$field = $this->fields->findBySlugAndNamespace($item['slug'], $item['namespace'])) {
                $field = $this->fields->create([
                    'name' => $item['name'],
                    'namespace' => $item['namespace'],
                    'slug' => $item['slug'],
                    'type' => $item['type'],
                    'config' => $item['config'],
                    'locked' => 0
                ]);
            }

            if (!$assigned_field = $this->assignments->findByStreamAndField($stream, $field)) {
                $this->assignments->create(['stream_id' => $stream->getId(), 'field_id' => $field->getId()]);
            }
        }
    }
}