<?php namespace Visiosoft\PatronModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Support\Facades\DB;
use Visiosoft\PatronModule\Analytic\Contract\AnalyticRepositoryInterface;
use Visiosoft\PatronModule\Expense\Contract\ExpenseRepositoryInterface;
use Visiosoft\PatronModule\Traits\PatronTrait;

class ExpensesController extends PublicController
{
    use PatronTrait;

    private $expenseRepository;
    private $analyticRepository;

    public function __construct(
        ExpenseRepositoryInterface $expenseRepository,
        AnalyticRepositoryInterface $analyticRepository
    )
    {
        parent::__construct();
        $this->expenseRepository = $expenseRepository;
        $this->analyticRepository = $analyticRepository;
    }

    public function index()
    {
        $analytics = $this->getIncomeOrExpenseAnalytics($this->expenseRepository);

        return $this->view->make(
            'visiosoft.theme.patron::views/expenses/index', [
                'analytics' => $analytics,
            ]
        );
    }

    public function expenseAnalysis()
    {
        $expense_monthly = $this->expenseRepository->newQuery()
            ->leftJoin('patron_items', 'patron_expenses.item_id', 'patron_items.id')
            ->select(DB::raw('sum(total) as `price`,date,item_id,name'), DB::raw('YEAR(date) year,MONTH(date) month'))
            ->whereRaw('YEAR(date) = "' . now()->format('Y') . '"')
            ->groupby('item_id', 'month')
            ->get();

        $expense_array = [];
        if (count($expense_monthly)) {
            foreach ($expense_monthly->toArray() as $expense) {
                $expense_array[$expense['name']]['monthly'][$expense['month']] = $expense;
            }
        }

        $expense_yearly = $this->expenseRepository->newQuery()
            ->leftJoin('patron_items', 'patron_expenses.item_id', 'patron_items.id')
            ->select(DB::raw('sum(total) as `price`,date,item_id,name'), DB::raw('YEAR(date) year'))
            ->groupby('item_id', 'year')
            ->get();

        if (count($expense_yearly)) {
            foreach ($expense_yearly->toArray() as $expense) {
                $expense_array[$expense['name']]['yearly'][$expense['year']] = $expense;
            }
        }

        //Calculate Total
        $total = ['month' => [],'year' => []];
        foreach ($expense_array as $expense)
        {
            foreach ($expense['monthly'] as $month_name => $month)
            {
                if(!isset($total['month'][$month_name]))
                {
                    $total['month'][$month_name] = 0;
                }
                $total['month'][$month_name] += $month['price'];
            }
            foreach ($expense['yearly'] as $year_name => $year)
            {
                if(!isset($total['year'][$year_name]))
                {
                    $total['year'][$year_name] = 0;
                }
                $total['year'][$year_name] += $year['price'];
            }
        }

        return $this->view->make('module::expense-analysis', compact('expense_array','total'));
    }
}
